"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverlayBannersService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _priority_map = require("./priority_map");
var _banners_list = require("./banners_list");
var _user_banner_service = require("./user_banner_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/overlays/browser-internal/src/banners/banners_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/** @internal */

/** @internal */
class OverlayBannersService {
  constructor() {
    (0, _defineProperty2.default)(this, "userBanner", new _user_banner_service.UserBannerService());
  }
  start({
    uiSettings,
    ...startServices
  }) {
    let uniqueId = 0;
    const genId = () => `${uniqueId++}`;
    const banners$ = new _rxjs.BehaviorSubject(new _priority_map.PriorityMap());
    const service = {
      add: (mount, priority = 0) => {
        const id = genId();
        const nextBanner = {
          id,
          mount,
          priority
        };
        banners$.next(banners$.value.add(id, nextBanner));
        return id;
      },
      remove: id => {
        if (!banners$.value.has(id)) {
          return false;
        }
        banners$.next(banners$.value.remove(id));
        return true;
      },
      replace(id, mount, priority = 0) {
        if (!id || !banners$.value.has(id)) {
          return this.add(mount, priority);
        }
        const nextId = genId();
        const nextBanner = {
          id: nextId,
          mount,
          priority
        };
        banners$.next(banners$.value.remove(id).add(nextId, nextBanner));
        return nextId;
      },
      get$() {
        return banners$.pipe((0, _rxjs.map)(bannerMap => [...bannerMap.values()]));
      },
      getComponent() {
        return /*#__PURE__*/_react.default.createElement(_banners_list.BannersList, {
          banners$: this.get$(),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 88,
            columnNumber: 16
          }
        });
      }
    };
    this.userBanner.start({
      banners: service,
      uiSettings,
      ...startServices
    });
    return service;
  }
  stop() {
    this.userBanner.stop();
  }
}
exports.OverlayBannersService = OverlayBannersService;