"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BannersList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/overlays/browser-internal/src/banners/banners_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * BannersList is a list of "banners". A banner something that is displayed at the top of Kibana that may or may not
 * disappear.
 *
 * Whether or not a banner can be closed is completely up to the author of the banner. Some banners make sense to be
 * static, such as banners meant to indicate the sensitivity (e.g., classification) of the information being
 * represented.
 */
const BannersList = ({
  banners$
}) => {
  const [banners, setBanners] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    const subscription = banners$.subscribe(setBanners);
    return () => subscription.unsubscribe();
  }, [banners$]); // Only un/re-subscribe if the Observable changes

  if (banners.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnGlobalBannerList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, banners.map(banner => /*#__PURE__*/_react.default.createElement(BannerItem, {
    key: banner.id,
    banner: banner,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  })));
};
exports.BannersList = BannersList;
const BannerItem = ({
  banner
}) => {
  const element = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => banner.mount(element.current), [banner]); // Only unmount / remount if banner object changed.

  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-priority": banner.priority,
    css: ({
      euiTheme
    }) => ({
      '& + &': {
        marginTop: euiTheme.size.s
      }
    }),
    ref: element,
    "data-test-subj": "global-banner-item",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  });
};