"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeSliderControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _constants = require("../../../constants");
var _range_slider_strings = require("../range_slider_strings");
var _range_slider = require("./range_slider.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/data_controls/range_slider/components/range_slider_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RangeSliderControl = ({
  compressed,
  controlPanelClassName,
  isInvalid,
  isLoading,
  fieldName,
  max,
  min,
  step,
  uuid,
  value,
  fieldFormatter,
  onChange
}) => {
  const rangeSliderRef = (0, _react.useRef)(null);
  const [displayedValue, setDisplayedValue] = (0, _react.useState)(value !== null && value !== void 0 ? value : ['', '']);
  const debouncedOnChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(newRange => {
    onChange(newRange);
  }, 750), [onChange]);

  /**
   * This will recalculate the displayed min/max of the range slider to allow for selections smaller
   * than the `min` and larger than the `max`
   */
  const [displayedMin, displayedMax] = (0, _react.useMemo)(() => {
    if (min === undefined || max === undefined) return [-Infinity, Infinity];
    const selectedValue = value !== null && value !== void 0 ? value : ['', ''];
    const [selectedMin, selectedMax] = [selectedValue[0] === '' ? min : parseFloat(selectedValue[0]), selectedValue[1] === '' ? max : parseFloat(selectedValue[1])];
    if (!step) return [Math.min(selectedMin, min), Math.max(selectedMax, max !== null && max !== void 0 ? max : Infinity)];
    const minTick = Math.floor(Math.min(selectedMin, min) / step) * step;
    const maxTick = Math.ceil(Math.max(selectedMax, max) / step) * step;
    return [Math.min(selectedMin, min, minTick), Math.max(selectedMax, max !== null && max !== void 0 ? max : Infinity, maxTick)];
  }, [min, max, value, step]);

  /**
   * The following `useEffect` ensures that the changes to the value that come from the embeddable (for example,
   * from the `reset` button on the dashboard or via chaining) are reflected in the displayed value
   */
  (0, _react.useEffect)(() => {
    setDisplayedValue(value !== null && value !== void 0 ? value : ['', '']);
  }, [value]);
  const ticks = (0, _react.useMemo)(() => {
    return [{
      value: displayedMin !== null && displayedMin !== void 0 ? displayedMin : -Infinity,
      label: fieldFormatter ? fieldFormatter(String(displayedMin)) : displayedMin
    }, {
      value: displayedMax !== null && displayedMax !== void 0 ? displayedMax : Infinity,
      label: fieldFormatter ? fieldFormatter(String(displayedMax)) : displayedMax
    }];
  }, [displayedMin, displayedMax, fieldFormatter]);
  const levels = (0, _react.useMemo)(() => {
    if (!step || min === undefined || max === undefined) {
      return [{
        min: min !== null && min !== void 0 ? min : -Infinity,
        max: max !== null && max !== void 0 ? max : Infinity,
        color: 'success'
      }];
    }
    const roundedMin = Math.floor(min / step) * step;
    const roundedMax = Math.ceil(max / step) * step;
    return [{
      min: roundedMin,
      max: roundedMax,
      color: 'success'
    }];
  }, [step, min, max]);
  const disablePopover = (0, _react.useMemo)(() => isLoading || displayedMin === -Infinity || displayedMax === Infinity || displayedMin === displayedMax, [isLoading, displayedMin, displayedMax]);
  const euiTheme = (0, _eui.useEuiTheme)();
  const styles = (0, _range_slider.rangeSliderControlStyles)(euiTheme);
  const getCommonInputProps = (0, _react.useCallback)(({
    inputValue,
    testSubj,
    placeholder,
    ariaLabel,
    id
  }) => {
    return {
      isInvalid: undefined,
      // disabling this prop to handle our own validation styling
      placeholder,
      readOnly: false,
      // overwrites `canOpenPopover` to ensure that the inputs are always clickable
      css: [styles.fieldNumbers.rangeSliderFieldNumber, isInvalid ? styles.fieldNumbers.invalid : styles.fieldNumbers.valid],
      className: 'rangeSliderAnchor__fieldNumber',
      value: inputValue,
      title: !isInvalid && step ? '' : undefined,
      // overwrites native number input validation error when the value falls between two steps
      'data-test-subj': `rangeSlider__${testSubj}`,
      'aria-label': ariaLabel,
      'aria-labelledby': `control-title-${id}`,
      id: `controls-range-slider-${id}`
    };
  }, [isInvalid, step, styles]);
  const minInputProps = (0, _react.useMemo)(() => {
    return getCommonInputProps({
      inputValue: displayedValue[0],
      testSubj: 'lowerBoundFieldNumber',
      placeholder: String(min !== null && min !== void 0 ? min : -Infinity),
      ariaLabel: _range_slider_strings.RangeSliderStrings.control.getLowerBoundAriaLabel(fieldName),
      id: `${uuid}-lowerBound`
    });
  }, [getCommonInputProps, displayedValue, min, fieldName, uuid]);
  const maxInputProps = (0, _react.useMemo)(() => {
    return getCommonInputProps({
      inputValue: displayedValue[1],
      testSubj: 'upperBoundFieldNumber',
      placeholder: String(max !== null && max !== void 0 ? max : Infinity),
      ariaLabel: _range_slider_strings.RangeSliderStrings.control.getUpperBoundAriaLabel(fieldName),
      id: `${uuid}-upperBound`
    });
  }, [getCommonInputProps, displayedValue, max, fieldName, uuid]);
  return /*#__PURE__*/_react.default.createElement("span", {
    css: [styles.rangeSliderControl, isInvalid && styles.invalid],
    className: "rangeSliderAnchor__button",
    "data-test-subj": `range-slider-control-${uuid}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDualRange, {
    ref: rangeSliderRef,
    id: uuid,
    fullWidth: true,
    showTicks: true,
    step: step,
    ticks: ticks,
    levels: levels,
    min: displayedMin,
    max: displayedMax,
    isLoading: isLoading,
    compressed: compressed,
    inputPopoverProps: {
      className: controlPanelClassName,
      panelMinWidth: _constants.MIN_POPOVER_WIDTH
    },
    append: isInvalid ? /*#__PURE__*/_react.default.createElement("div", {
      className: "rangeSlider__invalidToken",
      "data-test-subj": `range-slider-control-invalid-append-${uuid}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _range_slider_strings.RangeSliderStrings.control.getInvalidSelectionWarningLabel(),
      delay: "long",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
      tabIndex: 0,
      iconType: "alert",
      size: "s",
      color: "euiColorVis9",
      shape: "square",
      fill: "dark",
      title: _range_slider_strings.RangeSliderStrings.control.getInvalidSelectionWarningLabel(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 17
      }
    }))) : undefined,
    onMouseUp: () => {
      // when the pin is dropped (on mouse up), cancel any pending debounced changes and force the change
      // in value to happen instantly (which, in turn, will re-calculate the min/max for the slider due to
      // the `useEffect` above.
      debouncedOnChange.cancel();
      onChange(displayedValue);
    },
    readOnly: disablePopover,
    showInput: 'inputWithPopover',
    "data-test-subj": "rangeSlider__slider",
    minInputProps: minInputProps,
    maxInputProps: maxInputProps,
    value: [displayedValue[0] || displayedMin, displayedValue[1] || displayedMax],
    onChange: ([minSelection, maxSelection], _, ev) => {
      const originatingInputId = ev === null || ev === void 0 ? void 0 : ev.currentTarget.getAttribute('id');
      if (originatingInputId !== null && originatingInputId !== void 0 && originatingInputId.includes('lowerBound')) {
        // preserve original upper bound selection if only lower bound number field changed
        maxSelection = displayedValue[1];
      } else if (originatingInputId !== null && originatingInputId !== void 0 && originatingInputId.includes('upperBound')) {
        // preserve original lower bound selection if only upper bound number field changed
        minSelection = displayedValue[0];
      }
      setDisplayedValue([String(minSelection), String(maxSelection)]);
      debouncedOnChange([String(minSelection), String(maxSelection)]);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }));
};
exports.RangeSliderControl = RangeSliderControl;