"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _console_tour_step = require("./console_tour_step");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/components/top_nav_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const TopNavMenu = ({
  items,
  disabled,
  tourStepProps
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s",
    bottomBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, items.map((item, idx) => {
    const tab = /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: idx,
      disabled: disabled,
      onClick: item.onClick,
      title: item.label,
      "data-test-subj": item.testId,
      isSelected: item.isSelected,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 11
      }
    }, item.label);
    if (item.tourStep) {
      return /*#__PURE__*/_react.default.createElement(_console_tour_step.ConsoleTourStep, {
        tourStepProps: tourStepProps[item.tourStep - 1],
        key: idx,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 13
        }
      }, tab);
    }
    return tab;
  }));
};
exports.TopNavMenu = TopNavMenu;