"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.caseFilterOptions = exports.RecentCasesFilters = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/recent_cases/filters/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MY_RECENTLY_CREATED_ID = 'recentlyCreated';
const MY_RECENTLY_REPORTED_ID = 'myRecentlyReported';
const MY_RECENTLY_ASSIGNED_ID = 'myRecentlyAssigned';
const caseFilterOptions = exports.caseFilterOptions = [{
  id: MY_RECENTLY_CREATED_ID,
  label: i18n.RECENTLY_CREATED_CASES
}, {
  id: MY_RECENTLY_REPORTED_ID,
  label: i18n.MY_RECENTLY_REPORTED_CASES
}, {
  id: MY_RECENTLY_ASSIGNED_ID,
  label: i18n.MY_RECENTLY_ASSIGNED_CASES
}];
const RecentCasesFilters = exports.RecentCasesFilters = /*#__PURE__*/_react.default.memo(({
  filterBy,
  setFilterBy,
  hasCurrentUserInfo,
  isLoading = false
}) => {
  const options = caseFilterOptions.map(option => {
    return {
      value: option.id,
      text: option.label
    };
  });
  const onChange = (0, _react.useCallback)(e => {
    setFilterBy(e.target.value);
  }, [setFilterBy]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "recent-cases-filter",
    disabled: !hasCurrentUserInfo,
    fullWidth: true,
    hasNoInitialSelection: true,
    isLoading: isLoading,
    onChange: onChange,
    options: options,
    value: filterBy,
    "aria-label": i18n.RECENT_CASES,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  });
});
RecentCasesFilters.displayName = 'RecentCasesFilters';