"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Edit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _domain = require("../../../../common/types/domain");
var _view = require("./view");
var _translations = require("../translations");
var _config = require("./config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/custom_fields/number/edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isEmpty = value => {
  return value == null;
};
const FormWrapperComponent = ({
  initialValue,
  customFieldConfiguration,
  isLoading,
  onChange
}) => {
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      value: (customFieldConfiguration === null || customFieldConfiguration === void 0 ? void 0 : customFieldConfiguration.defaultValue) != null && isEmpty(initialValue) ? Number(customFieldConfiguration.defaultValue) : initialValue
    }
  });
  const [{
    value
  }] = (0, _hook_form_lib.useFormData)({
    form
  });
  const {
    submit,
    isValid
  } = form;
  const formFieldConfig = (0, _config.getNumberFieldConfig)({
    required: customFieldConfiguration.required,
    label: customFieldConfiguration.label
  });
  const populatedWithDefault = value === (customFieldConfiguration === null || customFieldConfiguration === void 0 ? void 0 : customFieldConfiguration.defaultValue) && isEmpty(initialValue);
  (0, _react.useEffect)(() => {
    onChange({
      value,
      isValid,
      submit
    });
  }, [isValid, onChange, submit, value]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "value",
    config: formFieldConfig,
    component: _components.NumericField,
    helpText: populatedWithDefault && _translations.POPULATED_WITH_DEFAULT,
    componentProps: {
      euiFieldProps: {
        fullWidth: true,
        disabled: isLoading,
        isLoading,
        'data-test-subj': `case-number-custom-field-form-field-${customFieldConfiguration.key}`
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }));
};
FormWrapperComponent.displayName = 'FormWrapper';
const EditComponent = ({
  customField,
  customFieldConfiguration,
  onSubmit,
  isLoading,
  canUpdate
}) => {
  var _customField$value;
  const initialValue = (_customField$value = customField === null || customField === void 0 ? void 0 : customField.value) !== null && _customField$value !== void 0 ? _customField$value : null;
  const [isEdit, setIsEdit] = (0, _react.useState)(false);
  const [formState, setFormState] = (0, _react.useState)({
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: {
        value: null
      }
    }),
    value: initialValue
  });
  const onEdit = (0, _react.useCallback)(() => {
    setIsEdit(true);
  }, []);
  const onCancel = (0, _react.useCallback)(() => {
    setIsEdit(false);
  }, []);
  const onSubmitCustomField = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data
    } = await formState.submit();
    if (isValid) {
      var _customField$key;
      onSubmit({
        ...customField,
        key: (_customField$key = customField === null || customField === void 0 ? void 0 : customField.key) !== null && _customField$key !== void 0 ? _customField$key : customFieldConfiguration.key,
        type: _domain.CustomFieldTypes.NUMBER,
        value: data.value ? Number(data.value) : null
      });
    }
    setIsEdit(false);
  }, [customField, customFieldConfiguration.key, formState, onSubmit]);
  const title = customFieldConfiguration.label;
  const isNumberFieldValid = formState.isValid || formState.value === customFieldConfiguration.defaultValue && isEmpty(initialValue);
  const isCustomFieldValueDefined = !isEmpty(customField === null || customField === void 0 ? void 0 : customField.value);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  }, title))), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": `case-number-custom-field-loading-${customFieldConfiguration.key}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }), !isLoading && canUpdate && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `case-number-custom-field-edit-button-${customFieldConfiguration.key}`,
    "aria-label": (0, _translations.EDIT_CUSTOM_FIELDS_ARIA_LABEL)(title),
    iconType: 'pencil',
    onClick: onEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    "data-test-subj": `case-number-custom-field-${customFieldConfiguration.key}`,
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, !isCustomFieldValueDefined && !isEdit && /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "no-number-custom-field-value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  }, _translations.NO_CUSTOM_FIELD_SET), !isEdit && isCustomFieldValueDefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_view.View, {
    customField: customField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  })), isEdit && canUpdate && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(FormWrapperComponent, {
    initialValue: initialValue,
    isLoading: isLoading,
    onChange: setFormState,
    customFieldConfiguration: customFieldConfiguration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": `case-number-custom-field-submit-button-${customFieldConfiguration.key}`,
    fill: true,
    iconType: "save",
    onClick: onSubmitCustomField,
    size: "s",
    disabled: !isNumberFieldValid || isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 19
    }
  }, _translations.SAVE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `case-number-custom-field-cancel-button-${customFieldConfiguration.key}`,
    iconType: "cross",
    onClick: onCancel,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 19
    }
  }, _translations.CANCEL)))))));
};
EditComponent.displayName = 'Edit';
const Edit = exports.Edit = /*#__PURE__*/_react.default.memo(EditComponent);