"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedElementsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _clone_subgraphs = require("../../lib/clone_subgraphs");
var _services = require("../../services");
var _transient = require("../../state/actions/transient");
var _elements = require("../../state/actions/elements");
var _workpad = require("../../state/selectors/workpad");
var _ui_metric = require("../../lib/ui_metric");
var _saved_elements_modal = require("./saved_elements_modal.component");
var _canvas_custom_element_service = require("../../services/canvas_custom_element_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/saved_elements_modal/saved_elements_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error untyped local
// @ts-expect-error untyped local
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const customElementAdded = 'elements-custom-added';
const SavedElementsModal = ({
  onClose
}) => {
  const notifyService = (0, _services.useNotifyService)();
  const customElementService = (0, _react.useMemo)(() => (0, _canvas_custom_element_service.getCustomElementService)(), []);
  const dispatch = (0, _reactRedux.useDispatch)();
  const pageId = (0, _reactRedux.useSelector)(_workpad.getSelectedPage);
  const [customElements, setCustomElements] = (0, _react.useState)([]);
  const onSearch = async (search = '') => {
    try {
      const {
        customElements: foundElements
      } = await customElementService.find(search);
      setCustomElements(foundElements);
    } catch (err) {
      notifyService.error(err, {
        title: `Couldn't find custom elements`
      });
    }
  };
  const onAddCustomElement = customElement => {
    const {
      selectedNodes = []
    } = JSON.parse(customElement.content) || {};
    const clonedNodes = selectedNodes && (0, _clone_subgraphs.cloneSubgraphs)(selectedNodes);
    if (clonedNodes) {
      dispatch((0, _elements.insertNodes)(clonedNodes, pageId)); // first clone and persist the new node(s)
      dispatch((0, _transient.selectToplevelNodes)(clonedNodes.filter(e => !e.position.parent).map(e => e.id))); // then select the cloned node(s)
    }
    onClose();
    (0, _ui_metric.trackCanvasUiMetric)(_ui_metric.METRIC_TYPE.LOADED, customElementAdded);
  };
  const onRemoveCustomElement = async id => {
    try {
      await customElementService.remove(id);
      await onSearch();
    } catch (err) {
      notifyService.error(err, {
        title: `Couldn't delete custom elements`
      });
    }
  };
  const onUpdateCustomElement = async (id, name, description, image) => {
    try {
      await customElementService.update(id, {
        name: (0, _lodash.camelCase)(name),
        displayName: name,
        image,
        help: description
      });
      await onSearch();
    } catch (err) {
      notifyService.error(err, {
        title: `Couldn't update custom elements`
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_saved_elements_modal.SavedElementsModal, {
    onAddCustomElement,
    onClose,
    onRemoveCustomElement,
    onSearch,
    onUpdateCustomElement,
    customElements,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  });
};
exports.SavedElementsModal = SavedElementsModal;