"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleGetSuggestedPaths = handleGetSuggestedPaths;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleGetSuggestedPaths({
  state,
  model
}) {
  const outputParser = new _output_parsers.JsonOutputParser();
  const suggestedPathsGraph = _prompts.SUGGESTED_PATHS_PROMPT.pipe(model).pipe(outputParser);
  const paths = await suggestedPathsGraph.invoke({
    data_stream_title: state.dataStreamName,
    path_options: state.pathOptions,
    ex_answer: _constants.EX_ANSWER_PATHS
  });
  return {
    suggestedPaths: paths,
    lastExecutedChain: 'getSuggestedPaths'
  };
}