"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmAlertingLatencyChartEmbeddableFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationContainers = require("@kbn/presentation-containers");
var _rxjs = require("rxjs");
var _embeddable_context = require("../../embeddable_context");
var _chart = require("./chart");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/embeddable/alerting/alerting_latency_chart/react_embeddable_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getApmAlertingLatencyChartEmbeddableFactory = deps => {
  const factory = {
    type: _constants.APM_ALERTING_LATENCY_CHART_EMBEDDABLE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      const state = initialState.rawState;
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(state);
      const serviceName$ = new _rxjs.BehaviorSubject(state.serviceName);
      const transactionType$ = new _rxjs.BehaviorSubject(state.transactionType);
      const transactionName$ = new _rxjs.BehaviorSubject(state.transactionName);
      const environment$ = new _rxjs.BehaviorSubject(state.environment);
      const latencyThresholdInMicroseconds$ = new _rxjs.BehaviorSubject(state.latencyThresholdInMicroseconds);
      const rangeFrom$ = new _rxjs.BehaviorSubject(state.rangeFrom);
      const rangeTo$ = new _rxjs.BehaviorSubject(state.rangeTo);
      const rule$ = new _rxjs.BehaviorSubject(state.rule);
      const alert$ = new _rxjs.BehaviorSubject(state.alert);
      const kuery$ = new _rxjs.BehaviorSubject(state.kuery);
      const filters$ = new _rxjs.BehaviorSubject(state.filters);
      function serializeState() {
        return {
          rawState: {
            ...titleManager.getLatestState(),
            serviceName: serviceName$.getValue(),
            transactionType: transactionType$.getValue(),
            transactionName: transactionName$.getValue(),
            environment: environment$.getValue(),
            latencyThresholdInMicroseconds: latencyThresholdInMicroseconds$.getValue(),
            rangeFrom: rangeFrom$.getValue(),
            rangeTo: rangeTo$.getValue(),
            rule: rule$.getValue(),
            alert: alert$.getValue(),
            kuery: kuery$.getValue(),
            filters: filters$.getValue()
          }
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        parentApi,
        uuid,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, serviceName$, transactionType$, transactionName$, environment$, latencyThresholdInMicroseconds$, rangeFrom$, rangeTo$, rule$, alert$, kuery$, filters$).pipe((0, _rxjs.map)(() => undefined)),
        getComparators: () => ({
          ..._presentationPublishing.titleComparators,
          serviceName: 'referenceEquality',
          transactionType: 'referenceEquality',
          transactionName: 'referenceEquality',
          environment: 'referenceEquality',
          latencyThresholdInMicroseconds: 'referenceEquality',
          rangeFrom: 'referenceEquality',
          rangeTo: 'referenceEquality',
          rule: 'referenceEquality',
          alert: 'referenceEquality',
          kuery: 'referenceEquality',
          filters: 'referenceEquality'
        }),
        onReset: lastSaved => {
          var _lastSaved$rawState$s;
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          serviceName$.next((_lastSaved$rawState$s = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.serviceName) !== null && _lastSaved$rawState$s !== void 0 ? _lastSaved$rawState$s : '');
          transactionType$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.transactionType);
          transactionName$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.transactionName);
          environment$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.environment);
          latencyThresholdInMicroseconds$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.latencyThresholdInMicroseconds);
          rangeFrom$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.rangeFrom);
          rangeTo$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.rangeTo);
          rule$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.rule);
          alert$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.alert);
          kuery$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.kuery);
          filters$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.filters);
        }
      });
      const api = finalizeApi({
        ...titleManager.api,
        ...unsavedChangesApi,
        serializeState
      });
      return {
        api,
        Component: () => {
          const [serviceName, transactionType, transactionName, environment, latencyThresholdInMicroseconds, rangeFrom, rangeTo, rule, alert, kuery, filters] = (0, _presentationPublishing.useBatchedPublishingSubjects)(serviceName$, transactionType$, transactionName$, environment$, latencyThresholdInMicroseconds$, rangeFrom$, rangeTo$, rule$, alert$, kuery$, filters$);
          return /*#__PURE__*/_react.default.createElement(_embeddable_context.ApmEmbeddableContext, {
            deps: deps,
            rangeFrom: rangeFrom,
            rangeTo: rangeTo,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 149,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_chart.APMAlertingLatencyChart, {
            rule: rule,
            alert: alert,
            latencyThresholdInMicroseconds: latencyThresholdInMicroseconds,
            serviceName: serviceName,
            transactionType: transactionType,
            environment: environment,
            rangeFrom: rangeFrom,
            rangeTo: rangeTo,
            transactionName: transactionName,
            kuery: kuery,
            filters: filters,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 150,
              columnNumber: 15
            }
          }));
        }
      };
    }
  };
  return factory;
};
exports.getApmAlertingLatencyChartEmbeddableFactory = getApmAlertingLatencyChartEmbeddableFactory;