"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenInDiscoverButton = OpenInDiscoverButton;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _esqlComposer = require("@kbn/esql-composer");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _base_discover_button = require("./base_discover_button");
var _filters = require("./filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/discover_links/open_in_discover_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getESQLQuery = ({
  params,
  indexSettings
}) => {
  if (!indexSettings || (indexSettings === null || indexSettings === void 0 ? void 0 : indexSettings.length) === 0) {
    return null;
  }
  const {
    serviceName,
    kuery,
    environment,
    transactionName,
    transactionType,
    sampleRangeFrom,
    sampleRangeTo,
    dependencyName,
    spanName
  } = params;
  const tracesIndices = indexSettings.filter(indexSetting => ['span', 'transaction'].includes(indexSetting.configurationName)).map(indexSetting => {
    var _indexSetting$savedVa;
    return (_indexSetting$savedVa = indexSetting.savedValue) !== null && _indexSetting$savedVa !== void 0 ? _indexSetting$savedVa : indexSetting.defaultValue;
  });
  const dedupedIndices = Array.from(new Set(tracesIndices)).join(',');
  const filters = [];
  if (serviceName) {
    filters.push((0, _filters.filterByServiceName)(serviceName));
  }
  if (environment && environment !== _environment_filter_values.ENVIRONMENT_ALL_VALUE && environment !== _environment_filter_values.ENVIRONMENT_NOT_DEFINED_VALUE) {
    filters.push((0, _filters.filterByEnvironment)(environment));
  }
  if (transactionName || spanName) {
    filters.push((0, _filters.filterByTransactionNameOrSpanName)(transactionName, spanName));
  }
  if (transactionType) {
    filters.push((0, _filters.filterByTransactionType)(transactionType));
  }
  if (dependencyName) {
    filters.push((0, _filters.filterByDependencyName)(dependencyName));
  }
  if (sampleRangeFrom && sampleRangeTo) {
    filters.push((0, _filters.filterBySampleRange)(sampleRangeFrom, sampleRangeTo, transactionName));
  }
  if (kuery) {
    filters.push((0, _filters.filterByKuery)(kuery));
  }
  return (0, _esqlComposer.from)(dedupedIndices).pipe(...filters).toString();
};
function OpenInDiscoverButton({
  dataTestSubj
}) {
  const {
    serviceName,
    indexSettings
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: queryParams
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view', '/dependencies/operation', '/traces/explorer/waterfall');
  const {
    rangeFrom,
    rangeTo,
    kuery,
    environment
  } = queryParams;
  const transactionName = 'transactionName' in queryParams ? queryParams.transactionName : undefined;
  const transactionType = 'transactionType' in queryParams ? queryParams.transactionType : undefined;
  const spanName = 'spanName' in queryParams ? queryParams.spanName : undefined;
  const sampleRangeFrom = 'sampleRangeFrom' in queryParams ? queryParams.sampleRangeFrom : undefined;
  const sampleRangeTo = 'sampleRangeTo' in queryParams ? queryParams.sampleRangeTo : undefined;
  const dependencyName = 'dependencyName' in queryParams ? queryParams.dependencyName : undefined;
  const params = {
    serviceName,
    kuery,
    environment,
    transactionName,
    transactionType,
    sampleRangeFrom,
    sampleRangeTo,
    dependencyName,
    spanName
  };
  const esqlQuery = getESQLQuery({
    params,
    indexSettings
  });
  return /*#__PURE__*/_react.default.createElement(_base_discover_button.BaseDiscoverButton, {
    dataTestSubj: dataTestSubj,
    esqlQuery: esqlQuery,
    rangeTo: rangeTo,
    rangeFrom: rangeFrom,
    label: _i18n.i18n.translate('xpack.apm.waterfallWithSummary.openInDiscoverButton.label', {
      defaultMessage: 'Open in Discover'
    }),
    ariaLabel: _i18n.i18n.translate('xpack.apm.waterfallWithSummary.openInDiscoverButton.ariaLabel', {
      defaultMessage: 'Open in Discover'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 5
    }
  });
}