"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Waterfall = Waterfall;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _timeline = require("../../../../../shared/charts/timeline");
var _get_agent_marks = require("../marks/get_agent_marks");
var _get_error_marks = require("../marks/get_error_marks");
var _accordion_waterfall = require("./accordion_waterfall");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Container = _styled.default.div`
  transition: 0.1s padding ease;
  position: relative;
`;
const WaterfallItemsContainer = _styled.default.div`
  border-bottom: 1px solid ${({
  theme
}) => theme.euiTheme.colors.mediumShade};
`;
function getWaterfallMaxLevel(waterfall) {
  var _waterfall$entryWater;
  const entryId = (_waterfall$entryWater = waterfall.entryWaterfallTransaction) === null || _waterfall$entryWater === void 0 ? void 0 : _waterfall$entryWater.id;
  if (!entryId) {
    return 0;
  }
  let maxLevel = 1;
  const visited = new Set();
  const queue = [{
    id: entryId,
    level: 1
  }];
  while (queue.length > 0) {
    const {
      id,
      level
    } = queue.shift();
    const children = waterfall.childrenByParentId[id] || [];
    maxLevel = Math.max(maxLevel, level);
    visited.add(id);
    children.forEach(child => {
      if (child.id !== id && !visited.has(child.id)) {
        queue.push({
          id: child.id,
          level: level + 1
        });
        visited.add(child.id);
      }
    });
  }
  return maxLevel;
}
const MAX_DEPTH_OPEN_LIMIT = 2;
function Waterfall({
  waterfall,
  waterfallItemId,
  showCriticalPath,
  onNodeClick,
  displayLimit,
  isEmbeddable,
  scrollElement,
  getRelatedErrorsHref
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isAccordionOpen, setIsAccordionOpen] = (0, _react2.useState)(true);
  const {
    duration
  } = waterfall;
  const agentMarks = (0, _get_agent_marks.getAgentMarks)(waterfall.entryTransaction);
  const errorMarks = (0, _get_error_marks.getErrorMarks)(waterfall.errorItems);
  const timelineMargins = (0, _react2.useMemo)(() => {
    // Calculate the left margin relative to the deepest level, or 100px, whichever
    // is more.
    const maxLevel = getWaterfallMaxLevel(waterfall);
    return {
      top: 40,
      left: Math.max(100, maxLevel * 10),
      right: 50,
      bottom: 0
    };
  }, [waterfall]);
  return /*#__PURE__*/_react2.default.createElement(Container, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, waterfall.exceedsMax && /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "apmWaterfallSizeWarning",
    color: "warning",
    size: "s",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.apm.waterfall.exceedsMax', {
      defaultMessage: 'The number of items in this trace is {traceDocsTotal} which is higher than the current limit of {maxTraceItems}. Please increase the limit via `xpack.apm.ui.maxTraceItems` to see the full trace',
      values: {
        traceDocsTotal: waterfall.traceDocsTotal,
        maxTraceItems: waterfall.maxTraceItems
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          display: flex;
          ${isEmbeddable ? 'position: relative;' : `
            position: sticky;
            top: var(--euiFixedHeadersOffset, 0);`}
          z-index: ${euiTheme.levels.menu};
          background-color: ${euiTheme.colors.emptyShade};
          border-bottom: 1px solid ${euiTheme.colors.mediumShade};
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "apmWaterfallButton",
    size: "m",
    css: (0, _react.css)`
            position: absolute;
            z-index: ${euiTheme.levels.menu};
            padding: ${euiTheme.size.m};
            width: auto;
          `,
    "aria-label": _i18n.i18n.translate('xpack.apm.waterfall.foldButton.ariaLabel', {
      defaultMessage: 'Click to {isAccordionOpen} the waterfall',
      values: {
        isAccordionOpen: isAccordionOpen ? _i18n.i18n.translate('xpack.apm.waterfall.foldButton.ariaLabel.fold', {
          defaultMessage: 'fold'
        }) : _i18n.i18n.translate('xpack.apm.waterfall.foldButton.ariaLabel.unfold', {
          defaultMessage: 'unfold'
        })
      }
    }),
    iconType: isAccordionOpen ? 'fold' : 'unfold',
    onClick: () => {
      setIsAccordionOpen(isOpen => !isOpen);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_timeline.TimelineAxisContainer, {
    marks: [...agentMarks, ...(isEmbeddable ? [] : errorMarks)],
    xMax: duration,
    margins: timelineMargins,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_timeline.VerticalLinesContainer, {
    marks: [...agentMarks, ...errorMarks],
    xMax: duration,
    margins: timelineMargins,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(WaterfallItemsContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }, !waterfall.entryWaterfallTransaction ? null : /*#__PURE__*/_react2.default.createElement(_accordion_waterfall.AccordionWaterfall, {
    isOpen: isAccordionOpen,
    waterfallItemId: waterfallItemId,
    duration: duration,
    waterfall: waterfall,
    timelineMargins: timelineMargins,
    onClickWaterfallItem: onNodeClick,
    showCriticalPath: showCriticalPath,
    maxLevelOpen: waterfall.traceDocsTotal > 500 ? MAX_DEPTH_OPEN_LIMIT : waterfall.traceDocsTotal,
    displayLimit: displayLimit,
    isEmbeddable: isEmbeddable,
    scrollElement: scrollElement,
    getRelatedErrorsHref: getRelatedErrorsHref,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  })));
}