"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopErrors = TopErrors;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _uuid = require("uuid");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _get_columns = require("../../../shared/errors_table/get_columns");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/top_errors/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INITIAL_STATE_MAIN_STATISTICS = {
  items: [],
  requestId: undefined
};
const INITIAL_STATE_DETAILED_STATISTICS = {
  currentPeriod: {},
  previousPeriod: {}
};
function TopErrors() {
  const {
    query,
    path: {
      serviceName
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view');
  const {
    environment,
    kuery,
    rangeFrom,
    rangeTo,
    offset,
    comparisonEnabled,
    transactionName,
    transactionType
  } = query;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data = INITIAL_STATE_MAIN_STATISTICS,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end && transactionType) {
      return callApmApi('GET /internal/apm/services/{serviceName}/errors/groups/main_statistics_by_transaction_name', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            transactionName,
            transactionType,
            maxNumberOfErrorGroups: 5
          }
        }
      }).then(response => {
        return {
          // Everytime the main statistics is refetched, updates the requestId making the comparison API to be refetched.
          requestId: (0, _uuid.v4)(),
          items: response.errorGroups
        };
      });
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [environment, kuery, start, end, serviceName, transactionName, transactionType,
  // not used, but needed to trigger an update when offset is changed either manually by user or when time range is changed
  offset,
  // not used, but needed to trigger an update when comparison feature is disabled/enabled by user
  comparisonEnabled]);
  const {
    requestId,
    items
  } = data;
  const {
    data: errorGroupDetailedStatistics = INITIAL_STATE_DETAILED_STATISTICS,
    status: errorGroupDetailedStatisticsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (requestId && items.length && start && end) {
      return callApmApi('POST /internal/apm/services/{serviceName}/errors/groups/detailed_statistics', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            numBuckets: 20,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
          },
          body: {
            groupIds: JSON.stringify(items.map(({
              groupId: groupId
            }) => groupId).sort())
          }
        }
      });
    }
  },
  // only fetches agg results when requestId changes

  // eslint-disable-next-line react-hooks/exhaustive-deps
  [requestId], {
    preservePreviousData: false
  });
  const errorGroupDetailedStatisticsLoading = errorGroupDetailedStatisticsStatus === _use_fetcher.FETCH_STATUS.LOADING;
  const columns = (0, _get_columns.getColumns)({
    serviceName,
    errorGroupDetailedStatisticsLoading,
    errorGroupDetailedStatistics,
    comparisonEnabled,
    query,
    showErrorType: false
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "topErrorsForTransactionTable",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.topErrors.title', {
    defaultMessage: 'Top 5 errors'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    error: status === _use_fetcher.FETCH_STATUS.FAILURE ? _i18n.i18n.translate('xpack.apm.transactionDetails.topErrors.errorMessage', {
      defaultMessage: 'Failed to fetch errors'
    }) : '',
    noItemsMessage: status === _use_fetcher.FETCH_STATUS.LOADING ? _i18n.i18n.translate('xpack.apm.transactionDetails.topErrors.loading', {
      defaultMessage: 'Loading...'
    }) : _i18n.i18n.translate('xpack.apm.transactionDetails.topErrors.noResults', {
      defaultMessage: 'No errors found for this transaction group'
    }),
    columns: columns,
    items: items,
    loading: status === _use_fetcher.FETCH_STATUS.LOADING,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  })));
}