"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = getColumns;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _service_nodes = require("../../../../../common/service_nodes");
var _formatters = require("../../../../../common/utils/formatters");
var _metric_overview_link = require("../../../shared/links/apm/metric_overview_link");
var _list_metric = require("../../../shared/list_metric");
var _get_latency_column_label = require("../../../shared/transactions_table/get_latency_column_label");
var _truncate_with_tooltip = require("../../../shared/truncate_with_tooltip");
var _instance_actions_menu = require("./instance_actions_menu");
var _get_timeseries_color = require("../../../shared/charts/helper/get_timeseries_color");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_overview/service_overview_instances_table/get_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getColumns({
  serviceName,
  kuery,
  latencyAggregationType,
  detailedStatsLoading,
  detailedStatsData,
  comparisonEnabled,
  toggleRowDetails,
  itemIdToExpandedRowMap,
  toggleRowActionMenu,
  itemIdToOpenActionMenuRowMap,
  offset,
  shouldShowSparkPlots = true,
  query
}) {
  return [{
    field: 'serviceNodeName',
    name: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTableColumnNodeName', {
      defaultMessage: 'Node name'
    }),
    width: '30%',
    render: (_, item) => {
      const {
        serviceNodeName
      } = item;
      const isMissingServiceNodeName = serviceNodeName === _service_nodes.SERVICE_NODE_NAME_MISSING;
      const text = (0, _service_nodes.getServiceNodeName)(serviceNodeName);
      const link = /*#__PURE__*/_react.default.createElement(_metric_overview_link.MetricOverviewLink, {
        serviceName: serviceName,
        query: {
          ...query,
          kuery: isMissingServiceNodeName ? `NOT (service.node.name:*)` : `service.node.name:"${item.serviceNodeName}"`
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 11
        }
      }, text);
      return /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
        text: text,
        content: link,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 16
        }
      });
    },
    sortable: true
  }, {
    field: 'latency',
    name: (0, _get_latency_column_label.getLatencyColumnLabel)(latencyAggregationType),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      serviceNodeName,
      latency
    }) => {
      var _detailedStatsData$cu, _detailedStatsData$cu2, _detailedStatsData$pr, _detailedStatsData$pr2;
      const currentPeriodTimestamp = detailedStatsData === null || detailedStatsData === void 0 ? void 0 : (_detailedStatsData$cu = detailedStatsData.currentPeriod) === null || _detailedStatsData$cu === void 0 ? void 0 : (_detailedStatsData$cu2 = _detailedStatsData$cu[serviceNodeName]) === null || _detailedStatsData$cu2 === void 0 ? void 0 : _detailedStatsData$cu2.latency;
      const previousPeriodTimestamp = detailedStatsData === null || detailedStatsData === void 0 ? void 0 : (_detailedStatsData$pr = detailedStatsData.previousPeriod) === null || _detailedStatsData$pr === void 0 ? void 0 : (_detailedStatsData$pr2 = _detailedStatsData$pr[serviceNodeName]) === null || _detailedStatsData$pr2 === void 0 ? void 0 : _detailedStatsData$pr2.latency;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_AVG);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        color: currentPeriodColor,
        valueLabel: (0, _formatters.asMillisecondDuration)(latency),
        hideSeries: !shouldShowSparkPlots,
        isLoading: detailedStatsLoading,
        series: currentPeriodTimestamp,
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriodTimestamp : undefined,
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 11
        }
      });
    },
    sortable: true
  }, {
    field: 'throughput',
    name: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTableColumnThroughput', {
      defaultMessage: 'Throughput'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      serviceNodeName,
      throughput
    }) => {
      var _detailedStatsData$cu3, _detailedStatsData$cu4, _detailedStatsData$pr3, _detailedStatsData$pr4;
      const currentPeriodTimestamp = detailedStatsData === null || detailedStatsData === void 0 ? void 0 : (_detailedStatsData$cu3 = detailedStatsData.currentPeriod) === null || _detailedStatsData$cu3 === void 0 ? void 0 : (_detailedStatsData$cu4 = _detailedStatsData$cu3[serviceNodeName]) === null || _detailedStatsData$cu4 === void 0 ? void 0 : _detailedStatsData$cu4.throughput;
      const previousPeriodTimestamp = detailedStatsData === null || detailedStatsData === void 0 ? void 0 : (_detailedStatsData$pr3 = detailedStatsData.previousPeriod) === null || _detailedStatsData$pr3 === void 0 ? void 0 : (_detailedStatsData$pr4 = _detailedStatsData$pr3[serviceNodeName]) === null || _detailedStatsData$pr4 === void 0 ? void 0 : _detailedStatsData$pr4.throughput;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.THROUGHPUT);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        compact: true,
        color: currentPeriodColor,
        hideSeries: !shouldShowSparkPlots,
        valueLabel: (0, _formatters.asTransactionRate)(throughput),
        isLoading: detailedStatsLoading,
        series: currentPeriodTimestamp,
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriodTimestamp : undefined,
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 11
        }
      });
    },
    sortable: true
  }, {
    field: 'errorRate',
    name: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTableColumnErrorRate', {
      defaultMessage: 'Failed transaction rate'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      serviceNodeName,
      errorRate
    }) => {
      var _detailedStatsData$cu5, _detailedStatsData$cu6, _detailedStatsData$pr5, _detailedStatsData$pr6;
      const currentPeriodTimestamp = detailedStatsData === null || detailedStatsData === void 0 ? void 0 : (_detailedStatsData$cu5 = detailedStatsData.currentPeriod) === null || _detailedStatsData$cu5 === void 0 ? void 0 : (_detailedStatsData$cu6 = _detailedStatsData$cu5[serviceNodeName]) === null || _detailedStatsData$cu6 === void 0 ? void 0 : _detailedStatsData$cu6.errorRate;
      const previousPeriodTimestamp = detailedStatsData === null || detailedStatsData === void 0 ? void 0 : (_detailedStatsData$pr5 = detailedStatsData.previousPeriod) === null || _detailedStatsData$pr5 === void 0 ? void 0 : (_detailedStatsData$pr6 = _detailedStatsData$pr5[serviceNodeName]) === null || _detailedStatsData$pr6 === void 0 ? void 0 : _detailedStatsData$pr6.errorRate;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.FAILED_TRANSACTION_RATE);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        compact: true,
        color: currentPeriodColor,
        hideSeries: !shouldShowSparkPlots,
        valueLabel: (0, _formatters.asPercent)(errorRate, 1),
        isLoading: detailedStatsLoading,
        series: currentPeriodTimestamp,
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriodTimestamp : undefined,
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 11
        }
      });
    },
    sortable: true
  }, {
    field: 'cpuUsage',
    name: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTableColumnCpuUsage', {
      defaultMessage: 'CPU usage (avg.)'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    sortable: true,
    render: (_, {
      serviceNodeName,
      cpuUsage
    }) => {
      var _detailedStatsData$cu7, _detailedStatsData$cu8, _detailedStatsData$pr7, _detailedStatsData$pr8;
      const currentPeriodTimestamp = detailedStatsData === null || detailedStatsData === void 0 ? void 0 : (_detailedStatsData$cu7 = detailedStatsData.currentPeriod) === null || _detailedStatsData$cu7 === void 0 ? void 0 : (_detailedStatsData$cu8 = _detailedStatsData$cu7[serviceNodeName]) === null || _detailedStatsData$cu8 === void 0 ? void 0 : _detailedStatsData$cu8.cpuUsage;
      const previousPeriodTimestamp = detailedStatsData === null || detailedStatsData === void 0 ? void 0 : (_detailedStatsData$pr7 = detailedStatsData.previousPeriod) === null || _detailedStatsData$pr7 === void 0 ? void 0 : (_detailedStatsData$pr8 = _detailedStatsData$pr7[serviceNodeName]) === null || _detailedStatsData$pr8 === void 0 ? void 0 : _detailedStatsData$pr8.cpuUsage;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.CPU_USAGE);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        compact: true,
        color: currentPeriodColor,
        hideSeries: !shouldShowSparkPlots,
        valueLabel: (0, _formatters.asPercent)(cpuUsage, 1),
        isLoading: detailedStatsLoading,
        series: currentPeriodTimestamp,
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriodTimestamp : undefined,
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'memoryUsage',
    name: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTableColumnMemoryUsage', {
      defaultMessage: 'Memory usage (avg.)'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    sortable: true,
    render: (_, {
      serviceNodeName,
      memoryUsage
    }) => {
      var _detailedStatsData$cu9, _detailedStatsData$cu10, _detailedStatsData$pr9, _detailedStatsData$pr10;
      const currentPeriodTimestamp = detailedStatsData === null || detailedStatsData === void 0 ? void 0 : (_detailedStatsData$cu9 = detailedStatsData.currentPeriod) === null || _detailedStatsData$cu9 === void 0 ? void 0 : (_detailedStatsData$cu10 = _detailedStatsData$cu9[serviceNodeName]) === null || _detailedStatsData$cu10 === void 0 ? void 0 : _detailedStatsData$cu10.memoryUsage;
      const previousPeriodTimestamp = detailedStatsData === null || detailedStatsData === void 0 ? void 0 : (_detailedStatsData$pr9 = detailedStatsData.previousPeriod) === null || _detailedStatsData$pr9 === void 0 ? void 0 : (_detailedStatsData$pr10 = _detailedStatsData$pr9[serviceNodeName]) === null || _detailedStatsData$pr10 === void 0 ? void 0 : _detailedStatsData$pr10.memoryUsage;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.MEMORY_USAGE);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        compact: true,
        color: currentPeriodColor,
        hideSeries: !shouldShowSparkPlots,
        valueLabel: (0, _formatters.asPercent)(memoryUsage, 1),
        isLoading: detailedStatsLoading,
        series: currentPeriodTimestamp,
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriodTimestamp : undefined,
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 241,
          columnNumber: 11
        }
      });
    }
  }, {
    width: '40px',
    render: instanceItem => {
      return /*#__PURE__*/_react.default.createElement(_public.ActionMenu, {
        id: "instanceActionMenu",
        closePopover: () => toggleRowActionMenu(instanceItem.serviceNodeName),
        isOpen: itemIdToOpenActionMenuRowMap[instanceItem.serviceNodeName],
        anchorPosition: "leftCenter",
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "aria-label": _i18n.i18n.translate('xpack.apm.getColumns.euiButtonIcon.editLabel', {
            defaultMessage: 'Edit'
          }),
          "data-test-subj": `instanceActionsButton_${instanceItem.serviceNodeName}`,
          iconType: "boxesHorizontal",
          onClick: () => toggleRowActionMenu(instanceItem.serviceNodeName),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 266,
            columnNumber: 15
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 260,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_instance_actions_menu.InstanceActionsMenu, {
        serviceName: serviceName,
        serviceNodeName: instanceItem.serviceNodeName,
        kuery: kuery,
        onClose: () => toggleRowActionMenu(instanceItem.serviceNodeName),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 276,
          columnNumber: 13
        }
      }));
    }
  }, {
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    render: instanceItem => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `instanceDetailsButton_${instanceItem.serviceNodeName}`,
        onClick: () => toggleRowDetails(instanceItem.serviceNodeName),
        "aria-label": itemIdToExpandedRowMap[instanceItem.serviceNodeName] ? 'Collapse' : 'Expand',
        iconType: itemIdToExpandedRowMap[instanceItem.serviceNodeName] ? 'arrowUp' : 'arrowDown',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 292,
          columnNumber: 11
        }
      });
    }
  }];
}