"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCountContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _aiopsComponents = require("@kbn/aiops-components");
var _constants = require("@kbn/aiops-common/constants");
var _use_aiops_app_context = require("../../../hooks/use_aiops_app_context");
var _total_count_header = require("../total_count_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/document_count_content/document_count_content/document_count_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DocumentCountContent = ({
  barColorOverride,
  barHighlightColorOverride,
  attachmentsMenu,
  ...docCountChartProps
}) => {
  const {
    data,
    uiSettings,
    fieldFormats,
    charts,
    embeddingOrigin
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    documentStats
  } = (0, _state.useAppSelector)(s => s.logRateAnalysis);
  const {
    sampleProbability,
    totalCount,
    documentCountStats
  } = documentStats;
  const isCasesEmbedding = embeddingOrigin === _constants.AIOPS_EMBEDDABLE_ORIGIN.CASES;
  const isEmbeddedInDashboardOrCases = embeddingOrigin === _constants.AIOPS_EMBEDDABLE_ORIGIN.DASHBOARD || isCasesEmbedding;
  if (documentCountStats === undefined) {
    return totalCount !== undefined && !isEmbeddedInDashboardOrCases ? /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
      totalCount: totalCount,
      sampleProbability: sampleProbability,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    }) : null;
  }
  if (isEmbeddedInDashboardOrCases) {
    return /*#__PURE__*/_react.default.createElement(_aiopsComponents.DocumentCountChartRedux, (0, _extends2.default)({
      dependencies: {
        data,
        uiSettings,
        fieldFormats,
        charts
      },
      barColorOverride: barColorOverride,
      barHighlightColorOverride: barHighlightColorOverride,
      changePoint: documentCountStats.changePoint,
      nonInteractive: isCasesEmbedding
    }, docCountChartProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
    totalCount: totalCount,
    sampleProbability: sampleProbability,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  })), attachmentsMenu && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 31
    }
  }, attachmentsMenu))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_aiopsComponents.DocumentCountChartRedux, (0, _extends2.default)({
    dependencies: {
      data,
      uiSettings,
      fieldFormats,
      charts
    },
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    changePoint: documentCountStats.changePoint
  }, docCountChartProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }))));
};
exports.DocumentCountContent = DocumentCountContent;