"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateEndpointPackagePolicy = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _errors = require("./errors");
var _controlled_artifact_rollout = require("../../../common/endpoint/utils/controlled_artifact_rollout");
var _types = require("../../../common/endpoint/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateEndpointPackagePolicy = (inputs, operation = 'create') => {
  var _input$config, _input$config$policy, _input$config2, _input$config2$artifa, _input$config3, _input$config3$policy, _input$config3$policy2, _input$config4, _input$config4$policy, _policyValue$windows, _policyValue$mac;
  const input = inputs.find(i => i.type === 'endpoint');

  // An elastic defend policy MUST have an input with expected policy and manifest data
  if (operation === 'update' && (!(input !== null && input !== void 0 && (_input$config = input.config) !== null && _input$config !== void 0 && (_input$config$policy = _input$config.policy) !== null && _input$config$policy !== void 0 && _input$config$policy.value) || !(input !== null && input !== void 0 && (_input$config2 = input.config) !== null && _input$config2 !== void 0 && (_input$config2$artifa = _input$config2.artifact_manifest) !== null && _input$config2$artifa !== void 0 && _input$config2$artifa.value))) {
    throw new _errors.EndpointIntegrationFleetError(`Invalid Elastic Defend security policy. 'inputs[0].config.policy.value' and 'inputs[0].config.artifact_manifest.value' are required.`);
  }

  // Validate global manifest versions
  if (input !== null && input !== void 0 && (_input$config3 = input.config) !== null && _input$config3 !== void 0 && (_input$config3$policy = _input$config3.policy) !== null && _input$config3$policy !== void 0 && (_input$config3$policy2 = _input$config3$policy.value) !== null && _input$config3$policy2 !== void 0 && _input$config3$policy2.global_manifest_version) {
    const globalManifestVersion = input.config.policy.value.global_manifest_version;
    if (globalManifestVersion !== 'latest') {
      const parsedDate = _moment.default.utc(globalManifestVersion, 'YYYY-MM-DD', true);
      if (!parsedDate.isValid()) {
        throw createManifestVersionError('Invalid date format. Use "latest" or "YYYY-MM-DD" format. UTC time.');
      }
      const maxAllowedDate = (0, _controlled_artifact_rollout.getControlledArtifactCutoffDate)();
      if (parsedDate.startOf('day').isBefore(maxAllowedDate.clone().startOf('day'))) {
        throw createManifestVersionError('Global manifest version is too far in the past. Please use either "latest" or a date within the last 18 months. The earliest valid date is October 1, 2023, in UTC time.');
      }
      const minAllowedDate = _moment.default.utc().subtract(1, 'day');
      if (parsedDate.isAfter(minAllowedDate)) {
        throw createManifestVersionError(`Global manifest version cannot be in the future. Latest selectable date is ${minAllowedDate.format('MMMM DD, YYYY')} UTC time.`);
      }
    }
  }

  // Validate device control notifications
  const policyValue = input === null || input === void 0 ? void 0 : (_input$config4 = input.config) === null || _input$config4 === void 0 ? void 0 : (_input$config4$policy = _input$config4.policy) === null || _input$config4$policy === void 0 ? void 0 : _input$config4$policy.value;
  if (policyValue !== null && policyValue !== void 0 && (_policyValue$windows = policyValue.windows) !== null && _policyValue$windows !== void 0 && _policyValue$windows.device_control || policyValue !== null && policyValue !== void 0 && (_policyValue$mac = policyValue.mac) !== null && _policyValue$mac !== void 0 && _policyValue$mac.device_control) {
    var _policyValue$windows2, _policyValue$windows3, _policyValue$mac2, _policyValue$mac2$dev, _policyValue$windows4, _policyValue$windows5, _policyValue$windows6, _policyValue$mac3, _policyValue$mac3$pop, _policyValue$mac3$pop2;
    const windowsAccessLevel = policyValue === null || policyValue === void 0 ? void 0 : (_policyValue$windows2 = policyValue.windows) === null || _policyValue$windows2 === void 0 ? void 0 : (_policyValue$windows3 = _policyValue$windows2.device_control) === null || _policyValue$windows3 === void 0 ? void 0 : _policyValue$windows3.usb_storage;
    const macAccessLevel = policyValue === null || policyValue === void 0 ? void 0 : (_policyValue$mac2 = policyValue.mac) === null || _policyValue$mac2 === void 0 ? void 0 : (_policyValue$mac2$dev = _policyValue$mac2.device_control) === null || _policyValue$mac2$dev === void 0 ? void 0 : _policyValue$mac2$dev.usb_storage;
    const windowsNotificationEnabled = policyValue === null || policyValue === void 0 ? void 0 : (_policyValue$windows4 = policyValue.windows) === null || _policyValue$windows4 === void 0 ? void 0 : (_policyValue$windows5 = _policyValue$windows4.popup) === null || _policyValue$windows5 === void 0 ? void 0 : (_policyValue$windows6 = _policyValue$windows5.device_control) === null || _policyValue$windows6 === void 0 ? void 0 : _policyValue$windows6.enabled;
    const macNotificationEnabled = policyValue === null || policyValue === void 0 ? void 0 : (_policyValue$mac3 = policyValue.mac) === null || _policyValue$mac3 === void 0 ? void 0 : (_policyValue$mac3$pop = _policyValue$mac3.popup) === null || _policyValue$mac3$pop === void 0 ? void 0 : (_policyValue$mac3$pop2 = _policyValue$mac3$pop.device_control) === null || _policyValue$mac3$pop2 === void 0 ? void 0 : _policyValue$mac3$pop2.enabled;
    if (windowsNotificationEnabled && windowsAccessLevel && windowsAccessLevel !== _types.DeviceControlAccessLevel.deny_all) {
      throw new _errors.EndpointIntegrationFleetError(`Device Control user notifications are only supported when USB storage access level is set to deny_all. Current Windows access level is "${windowsAccessLevel}". Please either set the access level to deny_all or disable user notifications.`);
    }
    if (macNotificationEnabled && macAccessLevel && macAccessLevel !== _types.DeviceControlAccessLevel.deny_all) {
      throw new _errors.EndpointIntegrationFleetError(`Device Control user notifications are only supported when USB storage access level is set to deny_all. Current Mac access level is "${macAccessLevel}". Please either set the access level to deny_all or disable user notifications.`);
    }
  }
};
exports.validateEndpointPackagePolicy = validateEndpointPackagePolicy;
const createManifestVersionError = message => {
  const manifestVersionError = new Error(message);
  manifestVersionError.statusCode = 400;
  manifestVersionError.apiPassThrough = true;
  return manifestVersionError;
};