"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildPolicyResponseFailureWorkflowInsights = buildPolicyResponseFailureWorkflowInsights;
var _moment = _interopRequireDefault(require("moment"));
var _workflow_insights = require("../../../../../common/endpoint/types/workflow_insights");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const groupSeparator = ':::';
async function buildPolicyResponseFailureWorkflowInsights({
  defendInsights,
  request
}) {
  const {
    insightType,
    endpointIds,
    apiConfig
  } = request.body;
  const currentTime = (0, _moment.default)();
  return defendInsights.filter(insight => insight.remediation && insight.remediation.message).map(insight => {
    var _apiConfig$model, _ref, _insight$remediation, _ref2, _insight$remediation2;
    const displayName = insight.group.split(groupSeparator)[1];
    const workflowInsight = {
      '@timestamp': currentTime,
      message: 'Policy response failure detected',
      category: _workflow_insights.Category.Endpoint,
      type: insightType,
      source: {
        type: _workflow_insights.SourceType.LlmConnector,
        id: apiConfig.connectorId,
        data_range_start: currentTime,
        data_range_end: currentTime
      },
      target: {
        type: _workflow_insights.TargetType.Endpoint,
        ids: endpointIds
      },
      action: {
        type: _workflow_insights.ActionType.Refreshed,
        timestamp: currentTime
      },
      value: insight.group,
      metadata: {
        notes: {
          llm_model: (_apiConfig$model = apiConfig.model) !== null && _apiConfig$model !== void 0 ? _apiConfig$model : ''
        },
        display_name: displayName
      },
      remediation: {
        descriptive: (_ref = (_insight$remediation = insight.remediation) === null || _insight$remediation === void 0 ? void 0 : _insight$remediation.message) !== null && _ref !== void 0 ? _ref : '',
        link: (_ref2 = (_insight$remediation2 = insight.remediation) === null || _insight$remediation2 === void 0 ? void 0 : _insight$remediation2.link) !== null && _ref2 !== void 0 ? _ref2 : ''
      }
    };
    return workflowInsight;
  });
}