"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowValueListModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_lists_privileges = require("../../detections/containers/detection_engine/lists/use_lists_privileges");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _value_list_modal = require("./value_list_modal");
var _telemetry = require("../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/value_list/components/show_value_list_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ShowValueListModal = ({
  listId,
  children,
  shouldShowContentIfModalNotAvailable
}) => {
  const [showModal, setShowModal] = (0, _react.useState)(false);
  const {
    canWriteIndex,
    canReadIndex,
    loading
  } = (0, _use_lists_privileges.useListsPrivileges)();
  const isValueItemsListModalEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('valueListItemsModalEnabled');
  const onCloseModal = (0, _react.useCallback)(() => setShowModal(false), []);
  const onShowModal = (0, _react.useCallback)(() => {
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, _telemetry.TELEMETRY_EVENT.OPEN_VALUE_LIST_MODAL);
    setShowModal(true);
  }, []);
  if (loading) return null;
  if (!canReadIndex || !isValueItemsListModalEnabled) {
    return shouldShowContentIfModalNotAvailable ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children) : null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `show-value-list-modal-${listId}`,
    onClick: onShowModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, children), showModal && /*#__PURE__*/_react.default.createElement(_value_list_modal.ValueListModal, {
    canWriteIndex: canWriteIndex !== null && canWriteIndex !== void 0 ? canWriteIndex : false,
    onCloseModal: onCloseModal,
    listId: listId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }));
};
exports.ShowValueListModal = ShowValueListModal;