"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetDiscoverCustomizationCallbacks = void 0;
var _use_histogram_customizations = require("./use_histogram_customizations");
var _use_search_bar_customizations = require("./use_search_bar_customizations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSetDiscoverCustomizationCallbacks = () => {
  const searchBarCustomizationCallback = (0, _use_search_bar_customizations.useSearchBarCustomizations)();
  const histogramCustomizationCallback = (0, _use_histogram_customizations.useHistogramCustomization)();
  return [searchBarCustomizationCallback, histogramCustomizationCallback];
};
exports.useSetDiscoverCustomizationCallbacks = useSetDiscoverCustomizationCallbacks;