"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostName = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _constants = require("../../../../../flyout/entity_details/shared/constants");
var _stateful_event_context = require("../../../../../common/components/events_viewer/stateful_event_context");
var _links = require("../../../../../common/components/links");
var _empty_value = require("../../../../../common/components/empty_value");
var _truncatable_text = require("../../../../../common/components/truncatable_text");
var _is_in_security_app = require("../../../../../common/hooks/is_in_security_app");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/host_name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HostNameComponent = ({
  Component,
  contextId,
  isButton,
  onClick,
  title,
  value
}) => {
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const isInSecurityApp = (0, _is_in_security_app.useIsInSecurityApp)();
  const eventContext = (0, _react.useContext)(_stateful_event_context.StatefulEventContext);
  const hostName = `${value}`;
  const isInTimelineContext = hostName && (eventContext === null || eventContext === void 0 ? void 0 : eventContext.enableHostDetailsFlyout) && (eventContext === null || eventContext === void 0 ? void 0 : eventContext.timelineID);
  const openHostDetailsSidePanel = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (onClick) {
      onClick();
    }

    /*
     * if and only if renderer is running inside security solution app
     * we check for event and timeline context
     * */
    if (!eventContext || !isInTimelineContext) {
      return;
    }
    const {
      timelineID
    } = eventContext;
    openFlyout({
      right: {
        id: _constants.HostPanelKey,
        params: {
          hostName,
          contextID: contextId,
          scopeId: timelineID
        }
      }
    });
  }, [contextId, eventContext, hostName, isInTimelineContext, onClick, openFlyout]);

  // The below is explicitly defined this way as the onClick takes precedence when it and the href are both defined
  // When this component is used outside of timeline/alerts table (i.e. in the flyout) we would still like it to link to the Host Details page
  const content = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
    Component: Component,
    hostName: hostName,
    isButton: isButton,
    onClick: isInTimelineContext || !isInSecurityApp ? openHostDetailsSidePanel : undefined,
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
    "data-test-subj": "draggable-truncatable-content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, hostName)), [Component, hostName, isButton, isInTimelineContext, openHostDetailsSidePanel, title, isInSecurityApp]);
  return (0, _fp.isString)(value) && hostName.length > 0 ? content : (0, _empty_value.getEmptyTagValue)();
};
const HostName = exports.HostName = /*#__PURE__*/_react.default.memo(HostNameComponent);
HostName.displayName = 'HostName';