"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventSummaryColumnRenderer = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("./constants");
var _get_row_renderer = require("./get_row_renderer");
var _plain_column_renderer = require("./plain_column_renderer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/event_summary_column_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EventRenderedFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  div:first-child {
    padding-left: 0px;

    div {
      margin: 0px;
    }
  }
`;
const eventSummaryColumnRenderer = exports.eventSummaryColumnRenderer = {
  isInstance: (0, _fp.isEqual)(_constants.EVENT_SUMMARY_FIELD_NAME),
  renderColumn: ({
    ecsData,
    columnName,
    eventId,
    field,
    isDetails,
    linkValues,
    rowRenderers = [],
    scopeId,
    truncate,
    values
  }) => {
    if (ecsData && rowRenderers) {
      return /*#__PURE__*/_react.default.createElement(SummaryCell, {
        ecsData: ecsData,
        key: `reason-column-renderer-value-${scopeId}-${columnName}-${eventId}-${field.id}`,
        rowRenderers: rowRenderers,
        scopeId: scopeId,
        values: values,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 9
        }
      });
    } else {
      return _plain_column_renderer.plainColumnRenderer.renderColumn({
        columnName,
        eventId,
        field,
        isDetails,
        linkValues,
        scopeId,
        truncate,
        values
      });
    }
  }
};
const SummaryCell = ({
  ecsData,
  rowRenderers,
  scopeId,
  values
}) => {
  const rowRenderer = (0, _react.useMemo)(() => (0, _get_row_renderer.getRowRenderer)({
    data: ecsData,
    rowRenderers
  }), [ecsData, rowRenderers]);
  const rowRender = (0, _react.useMemo)(() => {
    return rowRenderer && rowRenderer.renderRow({
      data: ecsData,
      scopeId
    });
  }, [rowRenderer, ecsData, scopeId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    className: "eui-fullWidth",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, rowRenderer && rowRender ? /*#__PURE__*/_react.default.createElement(EventRenderedFlexItem, {
    className: "eui-xScroll",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-displayInlineBlock",
    css: {
      width: 'fit-content'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, rowRender)) : values && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "plain-text-reason",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 19
    }
  }, values));
};