"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowRenderersBrowser = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _catalog = require("./catalog");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/row_renderers_browser/row_renderers_browser.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const StyledEuiInMemoryTable = (0, _styledComponents.default)(_eui.EuiInMemoryTable)`
  .euiTable {
    tr:has(.isNotSelected) {
      background-color: ${props => props.theme.eui.euiColorLightestShade};
    }

    tr > *:last-child {
      display: none;
    }

    .euiTableHeaderCellCheckbox > .euiTableCellContent {
      display: none; // we don't want to display checkbox in the table
    }
  }
`;
const StyledEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow: auto;

  > div {
    padding: 0;

    > div {
      margin: 0;
    }
  }
`;
const ExampleWrapperComponent = Example => {
  if (!Example) return;
  return /*#__PURE__*/_react.default.createElement(StyledEuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Example, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
};
const search = {
  box: {
    incremental: true,
    schema: true
  }
};

/**
 * Since `searchableDescription` contains raw text to power the Search bar,
 * this "noop" function ensures it's not actually rendered
 */
const renderSearchableDescriptionNoop = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
const initialSorting = {
  sort: {
    field: 'name',
    direction: 'asc'
  }
};
const StyledNameButton = _styledComponents.default.button`
  text-align: left;
`;
const RowRenderersBrowserComponent = ({
  excludedRowRendererIds = [],
  setExcludedRowRendererIds
}) => {
  const handleNameClick = (0, _react.useCallback)(item => () => {
    const newSelection = (0, _fp.xor)([item.id], excludedRowRendererIds);
    setExcludedRowRendererIds(newSelection);
  }, [excludedRowRendererIds, setExcludedRowRendererIds]);
  const nameColumnRenderCallback = (0, _react.useCallback)((value, item) => /*#__PURE__*/_react.default.createElement(StyledNameButton, {
    className: "kbn-resetFocusState",
    onClick: handleNameClick(item),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, value), [handleNameClick]);
  const idColumnRenderCallback = (0, _react.useCallback)((_, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: item.id,
    onChange: handleNameClick(item),
    className: `${!excludedRowRendererIds.includes(item.id) ? 'isSelected' : 'isNotSelected'}`,
    checked: !excludedRowRendererIds.includes(item.id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }), [excludedRowRendererIds, handleNameClick]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'id',
    name: '',
    sortable: false,
    width: '32px',
    render: idColumnRenderCallback,
    'data-test-subj': 'renderer-checkbox'
  }, {
    field: 'name',
    name: 'Name',
    sortable: true,
    width: '10%',
    render: nameColumnRenderCallback,
    'data-test-subj': 'renderer-name'
  }, {
    field: 'description',
    name: 'Description',
    width: '25%',
    render: description => description,
    'data-test-subj': 'renderer-description'
  }, {
    field: 'example',
    name: 'Example',
    width: '65%',
    render: ExampleWrapperComponent,
    'data-test-subj': 'renderer-example'
  }, {
    field: 'searchableDescription',
    name: 'Searchable Description',
    sortable: false,
    width: '0px',
    render: renderSearchableDescriptionNoop,
    'data-test-subj': 'renderer-searchable-description'
  }], [idColumnRenderCallback, nameColumnRenderCallback]);
  return /*#__PURE__*/_react.default.createElement(StyledEuiInMemoryTable, {
    items: _catalog.renderers,
    itemId: "id",
    columns: columns,
    search: search,
    sorting: initialSorting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 5
    }
  });
};
RowRenderersBrowserComponent.displayName = 'RowRenderersBrowserComponent';
const RowRenderersBrowser = exports.RowRenderersBrowser = /*#__PURE__*/_react.default.memo(RowRenderersBrowserComponent);
RowRenderersBrowser.displayName = 'RowRenderersBrowser';