"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowRendererSwitch = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _timeline = require("../../../../common/api/timeline");
var _actions = require("../../store/actions");
var _selectors = require("../../store/selectors");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/row_renderer_switch/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RowRendererSwitch = exports.RowRendererSwitch = /*#__PURE__*/_react.default.memo(function RowRendererSwitch(props) {
  const toggleTextSwitchId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'rowRendererSwitch'
  });
  const {
    timelineId
  } = props;
  const dispatch = (0, _reactRedux.useDispatch)();
  const excludedRowRendererIds = (0, _reactRedux.useSelector)(state => (0, _selectors.selectExcludedRowRendererIds)(state, timelineId));
  const isAnyRowRendererEnabled = (0, _react.useMemo)(() => _timeline.RowRendererValues.some(id => !excludedRowRendererIds.includes(id)), [excludedRowRendererIds]);
  const handleDisableAll = (0, _react.useCallback)(() => {
    dispatch((0, _actions.setExcludedRowRendererIds)({
      id: timelineId,
      excludedRowRendererIds: _timeline.RowRendererValues
    }));
  }, [dispatch, timelineId]);
  const handleEnableAll = (0, _react.useCallback)(() => {
    dispatch((0, _actions.setExcludedRowRendererIds)({
      id: timelineId,
      excludedRowRendererIds: []
    }));
  }, [dispatch, timelineId]);
  const onChange = (0, _react.useCallback)(e => {
    if (e.target.checked) {
      handleEnableAll();
    } else {
      handleDisableAll();
    }
  }, [handleDisableAll, handleEnableAll]);
  const rowRendererLabel = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement("span", {
    id: toggleTextSwitchId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, i18n.EVENT_RENDERERS_SWITCH), [toggleTextSwitchId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18n.EVENT_RENDERERS_SWITCH_WARNING,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "row-renderer-switch",
    label: rowRendererLabel,
    checked: isAnyRowRendererEnabled,
    onChange: onChange,
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  })));
});