"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormattedIp = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _stateful_event_context = require("../../../common/components/events_viewer/stateful_event_context");
var _network = require("../../../../common/search_strategy/security_solution/network");
var _empty_value = require("../../../common/components/empty_value");
var _links = require("../../../common/components/links");
var _network_details = require("../../../flyout/network_details");
var _flyout_link = require("../../../flyout/shared/components/flyout_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/formatted_ip/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tryStringify = value => {
  try {
    return JSON.stringify(value);
  } catch (_) {
    return `${value}`;
  }
};
const NonDecoratedIpComponent = ({
  value
}) => {
  const content = (0, _react.useMemo)(() => typeof value !== 'object' ? (0, _empty_value.getOrEmptyTagFromValue)(value) : (0, _empty_value.getOrEmptyTagFromValue)(tryStringify(value)), [value]);
  return content;
};
const NonDecoratedIp = /*#__PURE__*/_react.default.memo(NonDecoratedIpComponent);
const AddressLinksItemComponent = ({
  address,
  Component,
  fieldName,
  isButton,
  onClick,
  title
}) => {
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const eventContext = (0, _react.useContext)(_stateful_event_context.StatefulEventContext);
  const openNetworkDetailsSidePanel = (0, _react.useCallback)(ip => {
    if (onClick) {
      onClick();
    }
    if (eventContext) {
      openFlyout({
        right: {
          id: _network_details.NetworkPanelKey,
          params: {
            ip,
            scopeId: eventContext.timelineID,
            flowTarget: fieldName.includes(_network.FlowTargetSourceDest.destination) ? _network.FlowTargetSourceDest.destination : _network.FlowTargetSourceDest.source
          }
        }
      });
    }
  }, [onClick, eventContext, fieldName, openFlyout]);

  // The below is explicitly defined this way as the onClick takes precedence when it and the href are both defined
  // When this component is used outside of timeline/alerts table (i.e. in the flyout) we would still like it to link to the IP Overview page
  const content = (0, _react.useMemo)(() => {
    var _eventContext$timelin;
    return Component ? /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
      Component: Component,
      ip: address,
      isButton: isButton,
      onClick: openNetworkDetailsSidePanel,
      title: title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }) : /*#__PURE__*/_react.default.createElement(_flyout_link.FlyoutLink, {
      field: fieldName,
      value: address,
      scopeId: (_eventContext$timelin = eventContext === null || eventContext === void 0 ? void 0 : eventContext.timelineID) !== null && _eventContext$timelin !== void 0 ? _eventContext$timelin : '',
      "data-test-subj": "network-details",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    });
  }, [Component, address, isButton, openNetworkDetailsSidePanel, title, eventContext === null || eventContext === void 0 ? void 0 : eventContext.timelineID, fieldName]);
  return content;
};
const AddressLinksItem = /*#__PURE__*/_react.default.memo(AddressLinksItemComponent);
const AddressLinksComponent = ({
  addresses,
  Component,
  fieldName,
  isButton,
  onClick,
  title
}) => {
  const uniqAddresses = (0, _react.useMemo)(() => (0, _fp.uniq)(addresses), [addresses]);
  const content = (0, _react.useMemo)(() => uniqAddresses.map(address => /*#__PURE__*/_react.default.createElement(AddressLinksItem, {
    key: address,
    address: address,
    Component: Component,
    fieldName: fieldName,
    isButton: isButton,
    onClick: onClick,
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  })), [Component, fieldName, isButton, onClick, title, uniqAddresses]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content);
};
const AddressLinks = /*#__PURE__*/_react.default.memo(AddressLinksComponent, (prevProps, nextProps) => prevProps.fieldName === nextProps.fieldName && (0, _fastDeepEqual.default)(prevProps.addresses, nextProps.addresses));
const FormattedIpComponent = ({
  Component,
  fieldName,
  isButton,
  onClick,
  title,
  value
}) => {
  if ((0, _fp.isString)(value) && !(0, _fp.isEmpty)(value)) {
    try {
      const addresses = JSON.parse(value);
      if ((0, _fp.isArray)(addresses)) {
        return /*#__PURE__*/_react.default.createElement(AddressLinks, {
          addresses: addresses,
          Component: Component,
          fieldName: fieldName,
          isButton: isButton,
          onClick: onClick,
          title: title,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 178,
            columnNumber: 11
          }
        });
      }
    } catch (_) {
      // fall back to formatting it as a single link
    }

    // return a single draggable link
    return /*#__PURE__*/_react.default.createElement(AddressLinks, {
      addresses: [value],
      Component: Component,
      isButton: isButton,
      onClick: onClick,
      fieldName: fieldName,
      title: title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 7
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(NonDecoratedIp, {
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 12
      }
    });
  }
};
const FormattedIp = exports.FormattedIp = /*#__PURE__*/_react.default.memo(FormattedIpComponent, (prevProps, nextProps) => prevProps.fieldName === nextProps.fieldName && (0, _fastDeepEqual.default)(prevProps.value, nextProps.value));