"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateAttachmentsWithoutOwner = exports.generateAttachmentsMetadata = exports.generateAttachmentType = void 0;
var _common = require("@kbn/cases-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/threat_intelligence/constants");
var _common2 = require("../../../constants/common");
var _indicator = require("../../../../../common/threat_intelligence/types/indicator");
var _field_value = require("../../indicators/utils/field_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/cases/utils/attachments.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Indicator name, type, feed name and first seen values,
 * rendered in the comment section of a case's attachment or in the flyout
 */

const AttachmentChildrenLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/attachment_children'))));

/**
 * Create an {@link ExternalReferenceAttachmentType} object used to register an external reference
 * to the case plugin with our Threat Intelligence plugin initializes.
 *
 * See documentation here https://docs.elastic.dev/reops/attachment-framework-external-reference
 *
 * This object drives for example:
 * - the icon displayed in the case attachment
 * - the component that renders the comment in teh case attachment
 */
const generateAttachmentType = () => ({
  id: _constants.CASE_ATTACHMENT_TYPE_ID,
  displayName: 'indicator',
  getAttachmentViewObject: () => ({
    event: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.threatIntelligence.cases.eventDescription",
      defaultMessage: "added an indicator of compromise",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    }),
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      name: "indicator",
      color: "subdued",
      iconType: "crosshairs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 21
      }
    }),
    children: AttachmentChildrenLazy
  }),
  icon: 'crosshairs'
});

/**
 * Creates an attachment object, then passed to a case. It contains all the information necessary (id and metadata)
 * to allow the lazy loaded component defined within {@link generateAttachmentType} to render.
 *
 * See documentation here https://docs.elastic.dev/reops/attachment-framework-external-reference
 *
 * @param externalReferenceId the id saved in the case's attachment (in our case the indicator id)
 * @param attachmentMetadata some metadata also saved in the case's attachments for display in the comment
 */
exports.generateAttachmentType = generateAttachmentType;
const generateAttachmentsWithoutOwner = (externalReferenceId, attachmentMetadata) => {
  if (!externalReferenceId) {
    return [];
  }
  return [{
    type: _common.AttachmentType.externalReference,
    externalReferenceId,
    externalReferenceStorage: {
      type: _common.ExternalReferenceStorageType.elasticSearchDoc
    },
    externalReferenceAttachmentTypeId: _constants.CASE_ATTACHMENT_TYPE_ID,
    externalReferenceMetadata: attachmentMetadata
  }];
};

/**
 * To facilitate the rendering of the lazy loaded component defined in {@link generateAttachmentType}, we pass
 * some of the indicator's fields to be saved in the case's attachment.
 *
 * @param indicator the indicator we're attaching to a case
 */
exports.generateAttachmentsWithoutOwner = generateAttachmentsWithoutOwner;
const generateAttachmentsMetadata = indicator => {
  const indicatorName = (0, _field_value.getIndicatorFieldAndValue)(indicator, _indicator.RawIndicatorFieldId.Name).value;
  const indicatorType = (0, _field_value.getIndicatorFieldAndValue)(indicator, _indicator.RawIndicatorFieldId.Type).value;
  const indicatorFeedName = (0, _field_value.getIndicatorFieldAndValue)(indicator, _indicator.RawIndicatorFieldId.Feed).value;
  return {
    indicatorName: indicatorName || _common2.EMPTY_VALUE,
    indicatorType: indicatorType || _common2.EMPTY_VALUE,
    indicatorFeedName: indicatorFeedName || _common2.EMPTY_VALUE
  };
};
exports.generateAttachmentsMetadata = generateAttachmentsMetadata;