"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateDataView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _refresh_button = require("./refresh_button");
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var _sourcerer = require("../../../common/utils/sourcerer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/sourcerer/components/use_update_data_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useUpdateDataView = onOpenAndReset => {
  const {
    uiSettings,
    ...startServices
  } = (0, _kibana.useKibana)().services;
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _react.useCallback)(async missingPatterns => {
    const asyncSearch = async () => {
      try {
        const defaultPatterns = uiSettings.get(_constants.DEFAULT_INDEX_KEY);
        const uiSettingsIndexPattern = [...defaultPatterns, ...missingPatterns];
        const isSuccess = await uiSettings.set(_constants.DEFAULT_INDEX_KEY, (0, _sourcerer.ensurePatternFormat)(uiSettingsIndexPattern));
        return [isSuccess, null];
      } catch (e) {
        return [false, e];
      }
    };
    const [isUiSettingsSuccess, possibleError] = await asyncSearch();
    if (isUiSettingsSuccess) {
      addSuccess({
        color: 'success',
        title: (0, _reactKibanaMount.toMountPoint)(i18n.SUCCESS_TOAST_TITLE, startServices),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_refresh_button.RefreshButton, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 44,
            columnNumber: 30
          }
        }), startServices),
        iconType: undefined,
        toastLifeTimeMs: 600000
      });
      return true;
    }
    addError(possibleError !== null ? possibleError : new Error(i18n.FAILURE_TOAST_TITLE), {
      title: i18n.FAILURE_TOAST_TITLE,
      toastMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.indexPatterns.failureToastText",
        defaultMessage: "Unexpected error occurred on update. If you would like to modify your data, you can manually select a data view {link}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            onClick: onOpenAndReset,
            "data-test-subj": "failureToastLink",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 59,
              columnNumber: 19
            }
          }, i18n.TOGGLE_TO_NEW_SOURCERER)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 13
        }
      }))
    });
    return false;
  }, [addError, addSuccess, onOpenAndReset, uiSettings, startServices]);
};
exports.useUpdateDataView = useUpdateDataView;