"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateIndexPatternForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _kibana = require("../../../../../common/lib/kibana");
var _flyout = require("./flyout");
var _shared_imports = require("../../../../../shared_imports");
var _schema = require("./schema");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rules_table/update_index_pattern/update_index_pattern_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const initialFormData = {
  index: []
};
const UpdateIndexPatternForm = exports.UpdateIndexPatternForm = /*#__PURE__*/(0, _react.memo)(({
  onClose,
  onSubmit
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialFormData,
    schema: _schema.schema
  });
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const defaultPatterns = uiSettings.get(_constants.DEFAULT_INDEX_KEY);
  return /*#__PURE__*/_react.default.createElement(_flyout.IndexPatternPlaceholderFormWrapper, {
    form: form,
    title: i18n.INDEX_PATTERN_PLACEHOLDER_FORM_TITLE,
    onClose: onClose,
    onSubmit: onSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "index",
    config: {
      ..._schema.schema.index,
      label: i18n.INDEX_PATTERN_PLACEHOLDER_FORM_TITLE,
      helpText: i18n.INDEX_PATTERN_PLACEHOLDER_FORM_HELP_TEXT
    },
    componentProps: {
      idAria: 'updateIndexPatternIndexPatterns',
      'data-test-subj': 'updateIndexPatternIndexPatterns',
      euiFieldProps: {
        fullWidth: true,
        placeholder: '',
        noSuggestions: false,
        options: defaultPatterns.map(label => ({
          label
        }))
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
});
UpdateIndexPatternForm.displayName = 'UpdateIndexPatternForm';