"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesFileUpload = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _components = require("../../../../../../../common/components");
var _file_upload_error = require("../../../../../../../common/translations/file_upload_error");
var _use_parse_file_input = require("../../../../../../../common/hooks/use_parse_file_input");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/data_input_flyout/steps/rules/sub_steps/rules_file_upload/rules_file_upload.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RulesFileUpload = exports.RulesFileUpload = /*#__PURE__*/_react.default.memo(({
  createMigration,
  migrationName,
  apiError,
  isLoading,
  isCreated,
  onRulesFileChanged
}) => {
  const [rulesToUpload, setRulesToUpload] = (0, _react.useState)([]);
  const filePickerRef = (0, _react.useRef)(null);
  const createRules = (0, _react.useCallback)(() => {
    if (migrationName) {
      var _filePickerRef$curren;
      (_filePickerRef$curren = filePickerRef.current) === null || _filePickerRef$curren === void 0 ? void 0 : _filePickerRef$curren.removeFiles();
      createMigration(migrationName, rulesToUpload);
    }
  }, [createMigration, migrationName, rulesToUpload]);
  const onFileParsed = (0, _react.useCallback)(content => {
    const rules = content.map(formatRuleRow);
    setRulesToUpload(rules);
  }, []);
  const {
    parseFile,
    isParsing,
    error: fileError
  } = (0, _use_parse_file_input.useParseFileInput)(onFileParsed);
  const onFileChange = (0, _react.useCallback)(files => {
    setRulesToUpload([]);
    onRulesFileChanged(files);
    parseFile(files);
  }, [parseFile, onRulesFileChanged]);
  const error = (0, _react.useMemo)(() => {
    if (apiError) {
      return apiError;
    }
    return fileError;
  }, [apiError, fileError]);
  const showLoader = isParsing || isLoading;
  const isDisabled = !migrationName || showLoader || isCreated;
  const isButtonDisabled = isDisabled || rulesToUpload.length === 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: error != null,
    fullWidth: true,
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    isInvalid: error != null,
    id: "rulesFilePicker",
    ref: filePickerRef,
    fullWidth: true,
    initialPromptText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      textAlign: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 17
      }
    }, i18n.RULES_DATA_INPUT_FILE_UPLOAD_PROMPT),
    accept: "application/json, application/x-ndjson",
    onChange: onFileChange,
    display: "large",
    "aria-label": "Upload rules file",
    isLoading: showLoader,
    disabled: isDisabled,
    "data-test-subj": "rulesFilePicker",
    "data-loading": isParsing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_components.UploadFileButton, {
    onClick: createRules,
    isLoading: showLoader,
    disabled: isButtonDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  })))));
});
RulesFileUpload.displayName = 'RulesFileUpload';
const formatRuleRow = row => {
  var _row$result$actionEs;
  if (!(0, _lodash.isPlainObject)(row.result)) {
    throw new Error(_file_upload_error.FILE_UPLOAD_ERROR.NOT_OBJECT);
  }
  const originalRule = {
    id: row.result.id,
    vendor: 'splunk',
    title: row.result.title,
    query: row.result.search,
    query_language: 'spl',
    description: ((_row$result$actionEs = row.result['action.escu.eli5']) === null || _row$result$actionEs === void 0 ? void 0 : _row$result$actionEs.trim()) || row.result.description,
    severity: row.result['alert.severity']
  };
  if (row.result['action.correlationsearch.annotations']) {
    try {
      originalRule.annotations = JSON.parse(row.result['action.correlationsearch.annotations']);
    } catch (error) {
      delete originalRule.annotations;
    }
  }
  // rule document format validation delegated to API
  return originalRule;
};