"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSiemMigrationsRoutes = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../common/constants");
var _pages = require("./dashboards/pages");
var _pages2 = require("./rules/pages");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
var _landing = require("./landing");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SiemMigrationsLandingRoutes = () => {
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_security_route_page_wrapper.SecurityRoutePageWrapper, {
    pageName: _constants.SecurityPageName.siemMigrationsLanding,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.SIEM_MIGRATIONS_LANDING_PATH,
    component: _landing.MigrationsLandingPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 11
    }
  }))));
};
const SiemMigrationsRulesRoutes = () => {
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_security_route_page_wrapper.SecurityRoutePageWrapper, {
    pageName: _constants.SecurityPageName.siemMigrationsRules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.SIEM_MIGRATIONS_RULES_PATH}/:migrationId?`,
    component: _pages2.MigrationRulesPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }))));
};
const SiemMigrationsDashboardsRoutes = () => {
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_security_route_page_wrapper.SecurityRoutePageWrapper, {
    pageName: _constants.SecurityPageName.siemMigrationsDashboards,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.SIEM_MIGRATIONS_DASHBOARDS_PATH}/:migrationId?`,
    component: _pages.MigrationDashboardsPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }))));
};
const getSiemMigrationsRoutes = experimentalFeatures => {
  const isSiemMigrationsEnabled = !experimentalFeatures.siemMigrationsDisabled;
  const isAutomaticDashboardsMigrationEnabled = experimentalFeatures.automaticDashboardsMigration;
  return [...(isSiemMigrationsEnabled ? [{
    path: _constants.SIEM_MIGRATIONS_LANDING_PATH,
    component: SiemMigrationsLandingRoutes
  }, {
    path: _constants.SIEM_MIGRATIONS_RULES_PATH,
    component: SiemMigrationsRulesRoutes
  }] : []), ...(isSiemMigrationsEnabled && isAutomaticDashboardsMigrationEnabled ? [{
    path: _constants.SIEM_MIGRATIONS_DASHBOARDS_PATH,
    component: SiemMigrationsDashboardsRoutes
  }] : [])];
};
exports.getSiemMigrationsRoutes = getSiemMigrationsRoutes;