"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiemBaseMigrationsTelemetry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _siem_migrations = require("../../../common/lib/telemetry/events/siem_migrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SiemBaseMigrationsTelemetry {
  constructor(telemetryService, eventTypes) {
    (0, _defineProperty2.default)(this, "getBaseResultParams", error => ({
      result: error ? 'failed' : 'success',
      ...(error && {
        errorMessage: error.message
      })
    }));
    // Setup actions
    (0, _defineProperty2.default)(this, "reportConnectorSelected", params => {
      this.telemetryService.reportEvent(this.eventTypes.SetupConnectorSelected, {
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.SetupConnectorSelected],
        connectorId: params.connector.id,
        connectorType: params.connector.actionTypeId
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupMigrationOpen", params => {
      this.telemetryService.reportEvent(this.eventTypes.SetupMigrationOpenNew, {
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.SetupMigrationOpenNew],
        ...params
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupMigrationOpenResources", params => {
      this.telemetryService.reportEvent(this.eventTypes.SetupMigrationOpenResources, {
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.SetupMigrationOpenResources],
        ...params
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupMigrationCreated", params => {
      const {
        migrationId,
        rulesCount,
        error
      } = params;
      this.telemetryService.reportEvent(this.eventTypes.SetupMigrationCreated, {
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.SetupMigrationCreated],
        migrationId,
        rulesCount,
        ...this.getBaseResultParams(error)
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupMigrationDeleted", params => {
      const {
        migrationId,
        error
      } = params;
      this.telemetryService.reportEvent(this.eventTypes.SetupMigrationDeleted, {
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.SetupMigrationDeleted],
        migrationId,
        ...this.getBaseResultParams(error)
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupResourceUploaded", params => {
      const {
        migrationId,
        type,
        count,
        error
      } = params;
      this.telemetryService.reportEvent(this.eventTypes.SetupResourcesUploaded, {
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.SetupResourcesUploaded],
        migrationId,
        count,
        type,
        ...this.getBaseResultParams(error)
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupQueryCopied", params => {
      const {
        migrationId
      } = params;
      this.telemetryService.reportEvent(this.eventTypes.SetupQueryCopied, {
        migrationId,
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.SetupQueryCopied]
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupMacrosQueryCopied", params => {
      this.telemetryService.reportEvent(this.eventTypes.SetupMacrosQueryCopied, {
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.SetupMacrosQueryCopied],
        ...params
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupLookupNameCopied", params => {
      this.telemetryService.reportEvent(this.eventTypes.SetupLookupNameCopied, {
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.SetupLookupNameCopied],
        ...params
      });
    });
    (0, _defineProperty2.default)(this, "reportStopTranslation", params => {
      const {
        migrationId,
        error
      } = params;
      this.telemetryService.reportEvent(this.eventTypes.StopMigration, {
        migrationId,
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.StopMigration],
        ...this.getBaseResultParams(error)
      });
    });
    // Translated migration actions
    (0, _defineProperty2.default)(this, "reportTranslatedItemUpdate", params => {
      const {
        migrationItem,
        error
      } = params;
      this.telemetryService.reportEvent(this.eventTypes.TranslatedItemUpdate, {
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.TranslatedItemUpdate],
        migrationId: migrationItem.migration_id,
        ruleMigrationId: migrationItem.id,
        ...this.getBaseResultParams(error)
      });
    });
    (0, _defineProperty2.default)(this, "reportTranslatedItemInstall", params => {
      var _migrationItem$elasti;
      const {
        migrationItem,
        enabled,
        error
      } = params;
      const eventParams = {
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.TranslatedItemInstall],
        migrationId: migrationItem.migration_id,
        ruleMigrationId: migrationItem.id,
        author: 'custom',
        enabled,
        ...this.getBaseResultParams(error)
      };
      if ('elastic_rule' in migrationItem && (_migrationItem$elasti = migrationItem.elastic_rule) !== null && _migrationItem$elasti !== void 0 && _migrationItem$elasti.prebuilt_rule_id) {
        eventParams.author = 'elastic';
        eventParams.prebuiltRule = {
          id: migrationItem.elastic_rule.prebuilt_rule_id,
          title: migrationItem.elastic_rule.title
        };
      }
      this.telemetryService.reportEvent(this.eventTypes.TranslatedItemInstall, eventParams);
    });
    (0, _defineProperty2.default)(this, "reportTranslatedItemBulkInstall", params => {
      const {
        migrationId,
        count,
        enabled,
        error
      } = params;
      this.telemetryService.reportEvent(this.eventTypes.TranslatedBulkInstall, {
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.TranslatedBulkInstall],
        migrationId,
        count,
        enabled,
        ...this.getBaseResultParams(error)
      });
    });
    (0, _defineProperty2.default)(this, "reportStartTranslation", params => {
      var _settings$skipPrebuil;
      const {
        migrationId,
        settings,
        retry
      } = params;
      const error = 'error' in params ? params.error : undefined;
      this.telemetryService.reportEvent(this.eventTypes.StartMigration, {
        migrationId,
        connectorId: settings === null || settings === void 0 ? void 0 : settings.connectorId,
        isRetry: !!retry,
        skipPrebuiltRulesMatching: 'skipPrebuiltRulesMatching' in settings ? (_settings$skipPrebuil = settings.skipPrebuiltRulesMatching) !== null && _settings$skipPrebuil !== void 0 ? _settings$skipPrebuil : false : false,
        eventName: _siem_migrations.siemMigrationEventNames[this.eventTypes.StartMigration],
        ...(retry && {
          retryFilter: retry
        }),
        ...this.getBaseResultParams(error)
      });
    });
    this.telemetryService = telemetryService;
    this.eventTypes = eventTypes;
  }
}
exports.SiemBaseMigrationsTelemetry = SiemBaseMigrationsTelemetry;