"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNoConnectorToast = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../onboarding/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/common/service/notifications/no_connector_notification.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getNoConnectorToast = core => ({
  color: 'danger',
  iconType: 'alert',
  title: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.baseService.noConnector.title', {
    defaultMessage: 'No connector configured.'
  }),
  text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
    core: core,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(NoConnectorToastContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  })), core)
});
exports.getNoConnectorToast = getNoConnectorToast;
const navigation = {
  deepLinkId: _securitySolutionNavigation.SecurityPageName.landing,
  path: `${_constants.OnboardingTopicId.siemMigrations}#${_constants.OnboardingCardId.siemMigrationsAiConnectors}`
};
const NoConnectorToastContent = () => {
  const {
    navigateTo,
    getAppUrl
  } = (0, _securitySolutionNavigation.useNavigation)();
  const onClick = ev => {
    ev.preventDefault();
    navigateTo(navigation);
  };
  const url = getAppUrl(navigation);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.baseService.noConnector.text",
    defaultMessage: "No AI connector configured. Select an AI connector to start translations.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClick,
    href: url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.securitySolution.siemMigrations.baseService.noConnector.link', {
    defaultMessage: 'Go to connector selection'
  }))));
};