"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIEM_MIGRATIONS_SELECT_MIGRATION_BUTTON_ID = exports.HeaderButtons = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _constants = require("../../../../onboarding/constants");
var _links = require("../../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/common/components/header_buttons/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SIEM_MIGRATIONS_SELECT_MIGRATION_BUTTON_ID = exports.SIEM_MIGRATIONS_SELECT_MIGRATION_BUTTON_ID = 'siemMigrationsSelectMigrationButton';
const migrationStatsToComboBoxOption = stats => ({
  value: stats.id,
  label: stats.name,
  'data-test-subj': `migrationSelectionOption-${stats.id}`
});
const HeaderButtons = exports.HeaderButtons = /*#__PURE__*/_react.default.memo(({
  migrationType,
  migrationsStats,
  selectedMigrationId,
  onMigrationIdChange
}) => {
  const migrationOptions = (0, _react.useMemo)(() => migrationsStats.map(migrationStatsToComboBoxOption), [migrationsStats]);
  const selectedMigrationOption = (0, _react.useMemo)(() => {
    const stats = migrationsStats.find(({
      id
    }) => id === selectedMigrationId);
    return stats ? [migrationStatsToComboBoxOption(stats)] : [];
  }, [migrationsStats, selectedMigrationId]);
  const onChange = selected => {
    onMigrationIdChange(selected[0].value);
  };
  const addAnotherMigrationButton = (0, _react.useMemo)(() => {
    const onboardingCardId = migrationType === 'rule' ? _constants.OnboardingCardId.siemMigrationsRules : _constants.OnboardingCardId.siemMigrationsDashboards;
    return /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
      "data-test-subj": "addAnotherMigrationButton",
      iconType: "plusInCircle",
      deepLinkId: _deeplinksSecurity.SecurityPageName.landing,
      path: `${_constants.OnboardingTopicId.siemMigrations}#${onboardingCardId}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }, i18n.SIEM_MIGRATIONS_ADD_ANOTHER_MIGRATION_TITLE);
  }, [migrationType]);
  if (!migrationsStats.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "s",
    responsive: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            width: 400px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h6", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, i18n.SIEM_MIGRATIONS_OPTION_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    id: SIEM_MIGRATIONS_SELECT_MIGRATION_BUTTON_ID,
    "data-test-subj": SIEM_MIGRATIONS_SELECT_MIGRATION_BUTTON_ID,
    "aria-label": i18n.SIEM_MIGRATIONS_OPTION_AREAL_LABEL,
    onChange: onChange,
    options: migrationOptions,
    selectedOptions: selectedMigrationOption,
    singleSelection: {
      asPlainText: true
    },
    isClearable: false,
    inputPopoverProps: {
      css: (0, _react2.css)`
                & .euiComboBox__inputWrap div {
                  inline-size: 100%;
                }
              `
    },
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, addAnotherMigrationButton));
});
HeaderButtons.displayName = 'HeaderButtons';