"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueReportExporter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _pdfLib = require("pdf-lib");
var _domToImageMore = _interopRequireDefault(require("dom-to-image-more"));
var _kibana = require("../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/value_report_exporter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ValueReportExporterComponent = ({
  children
}) => {
  const exportRef = (0, _react.useRef)(null);
  const toasts = (0, _kibana.useToasts)();
  const uiAdjuster = (0, _react.useCallback)(eRef => {
    const valueReportSettings = eRef.querySelector('.valueReportSettings');
    const editTitleSvg = eRef.querySelector('.executiveSummaryTitle svg');
    const elementsToHide = [valueReportSettings, editTitleSvg];
    const adjustUI = () => {
      elementsToHide.forEach(e => {
        if (e) {
          e.setAttribute('data-original-style', e.getAttribute('style') || '');
          e.style.display = 'none';
        }
      });
    };
    const restoreUI = () => {
      elementsToHide.forEach(e => {
        if (e) {
          const original = e.getAttribute('data-original-style');
          if (original) {
            e.setAttribute('style', original);
          } else {
            e.removeAttribute('style');
          }
        }
      });
    };
    return {
      adjustUI,
      restoreUI
    };
  }, []);
  const handleExportPDF = (0, _react.useCallback)(async () => {
    if (!exportRef.current) return;
    const {
      adjustUI,
      restoreUI
    } = uiAdjuster(exportRef.current);
    adjustUI();
    try {
      const scale = 2;
      const blob = await _domToImageMore.default.toBlob(exportRef.current, {
        quality: 1,
        bgcolor: '#ffffff',
        cacheBust: true,
        width: exportRef.current.offsetWidth * scale,
        height: exportRef.current.offsetHeight * scale,
        style: {
          transform: `scale(${scale})`,
          transformOrigin: 'top left',
          width: `${exportRef.current.offsetWidth}px`,
          height: `${exportRef.current.offsetHeight}px`
        },
        styleFilter: style => {
          try {
            void style.cssRules;
            return true;
          } catch {
            return false;
          }
        }
      });
      const imageBytes = await blob.arrayBuffer();
      const pdfDoc = await _pdfLib.PDFDocument.create();
      const pageWidth = 595.28; // A4 width
      const pageHeight = 841.89; // A4 height
      const padding = 20;
      const page = pdfDoc.addPage([pageWidth, pageHeight]);
      const pngImage = await pdfDoc.embedPng(imageBytes);
      const originalWidth = pngImage.width;
      const originalHeight = pngImage.height;
      const maxWidth = pageWidth - padding * 2;
      const maxHeight = pageHeight - padding * 2;
      const widthScale = maxWidth / originalWidth;
      const heightScale = maxHeight / originalHeight;
      const pdfScale = Math.min(widthScale, heightScale);
      const imageWidth = originalWidth * pdfScale;
      const imageHeight = originalHeight * pdfScale;
      const x = (pageWidth - imageWidth) / 2;
      const y = pageHeight - padding - imageHeight;
      page.drawImage(pngImage, {
        x,
        y,
        width: imageWidth,
        height: imageHeight
      });
      const pdfBytes = await pdfDoc.save();
      const pdfBlob = new Blob([pdfBytes], {
        type: 'application/pdf'
      });
      const url = URL.createObjectURL(pdfBlob);
      const a = document.createElement('a');
      a.href = url;
      a.download = `value-report-${new Date().toISOString()}.pdf`;
      a.click();
      URL.revokeObjectURL(url);
    } catch (err) {
      var _err$message;
      toasts.addError(err, {
        title: 'Failed to export value report PDF',
        toastMessage: (_err$message = err.message) !== null && _err$message !== void 0 ? _err$message : 'An unexpected error occurred. Please try again later.'
      });
    } finally {
      restoreUI();
    }
  }, [toasts, uiAdjuster]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: exportRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 10
    }
  }, children(handleExportPDF));
};
const ValueReportExporter = exports.ValueReportExporter = /*#__PURE__*/_react.default.memo(ValueReportExporterComponent);