"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventCounts = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/data-plugin/common");
var _overview_host = require("../../containers/overview_host");
var _overview_host2 = require("../overview_host");
var _overview_network = require("../overview_network");
var _kibana = require("../../../common/lib/kibana");
var _kuery = require("../../../common/lib/kuery");
var _use_invalid_filter_query = require("../../../common/hooks/use_invalid_filter_query");
var _utils = require("../../../common/components/visualization_actions/utils");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/event_counts/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EventCountsComponent = ({
  filters,
  from,
  indexNames,
  dataViewSpec,
  dataView,
  query,
  setQuery,
  to
}) => {
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const [hostFilterQuery, hostKqlError] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    dataViewSpec,
    dataView,
    queries: [query],
    filters: [...filters, ...(0, _utils.fieldNameExistsFilter)(_constants.SecurityPageName.hosts)]
  }), [dataViewSpec, filters, dataView, query, uiSettings]);
  const [networkFilterQuery] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    dataViewSpec,
    dataView,
    queries: [query],
    filters: [...filters, ..._utils.sourceOrDestinationIpExistsFilter]
  }), [uiSettings, dataViewSpec, dataView, query, filters]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: _overview_host.ID,
    filterQuery: hostFilterQuery || networkFilterQuery,
    kqlError: hostKqlError,
    query,
    startDate: from,
    endDate: to
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_host2.OverviewHost, {
    endDate: to,
    filterQuery: hostFilterQuery,
    indexNames: indexNames,
    startDate: from,
    setQuery: setQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_network.OverviewNetwork, {
    endDate: to,
    filterQuery: networkFilterQuery,
    indexNames: indexNames,
    startDate: from,
    setQuery: setQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  })));
};
const EventCounts = exports.EventCounts = /*#__PURE__*/_react.default.memo(EventCountsComponent);