"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REFRESH = exports.NotesUtilityBar = exports.DELETE_SELECTED = exports.BATCH_ACTIONS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utility_bar = require("../../common/components/utility_bar");
var _ = require("..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/notes/components/utility_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BATCH_ACTIONS = exports.BATCH_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.notes.management.batchActionsTitle', {
  defaultMessage: 'Bulk actions'
});
const DELETE_SELECTED = exports.DELETE_SELECTED = _i18n.i18n.translate('xpack.securitySolution.notes.management.deleteSelected', {
  defaultMessage: 'Delete selected notes'
});
const REFRESH = exports.REFRESH = _i18n.i18n.translate('xpack.securitySolution.notes.management.refresh', {
  defaultMessage: 'Refresh'
});

/**
 * Renders the utility bar for the notes management page
 */
const NotesUtilityBar = exports.NotesUtilityBar = /*#__PURE__*/_react.default.memo(() => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const pagination = (0, _reactRedux.useSelector)(_.selectNotesPagination);
  const sort = (0, _reactRedux.useSelector)(_.selectNotesTableSort);
  const selectedItems = (0, _reactRedux.useSelector)(_.selectNotesTableSelectedIds);
  const notesCreatedByFilter = (0, _reactRedux.useSelector)(_.selectNotesTableCreatedByFilter);
  const notesAssociatedFilter = (0, _reactRedux.useSelector)(_.selectNotesTableAssociatedFilter);
  const resultsCount = (0, _react.useMemo)(() => {
    const {
      perPage,
      page,
      total
    } = pagination;
    const startOfCurrentPage = perPage * (page - 1) + 1;
    const endOfCurrentPage = Math.min(perPage * page, total);
    return perPage === 0 ? 'All' : `${startOfCurrentPage}-${endOfCurrentPage} of ${total}`;
  }, [pagination]);
  const deleteSelectedNotes = (0, _react.useCallback)(() => {
    dispatch((0, _.userSelectedBulkDelete)());
  }, [dispatch]);
  const notesSearch = (0, _reactRedux.useSelector)(_.selectNotesTableSearch);
  const BulkActionPopoverContent = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "notes-management-delete-notes",
      onClick: deleteSelectedNotes,
      disabled: selectedItems.length === 0,
      icon: "trash",
      key: "DeleteItemKey",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 7
      }
    }, DELETE_SELECTED);
  }, [deleteSelectedNotes, selectedItems.length]);
  const refresh = (0, _react.useCallback)(() => {
    dispatch((0, _.fetchNotes)({
      page: pagination.page,
      perPage: pagination.perPage,
      sortField: sort.field,
      sortOrder: sort.direction,
      filter: '',
      createdByFilter: notesCreatedByFilter,
      associatedFilter: notesAssociatedFilter,
      search: notesSearch
    }));
  }, [dispatch, pagination.page, pagination.perPage, sort.field, sort.direction, notesCreatedByFilter, notesAssociatedFilter, notesSearch]);
  return /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBar, {
    border: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    "data-test-subj": "notes-management-pagination-count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, `Showing: ${resultsCount}`)), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    "data-test-subj": "notes-management-selected-count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, selectedItems.length > 0 ? `${selectedItems.length} selected` : ''), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "notes-management-utility-bar-actions",
    iconSide: "right",
    iconType: "arrowDown",
    popoverContent: BulkActionPopoverContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "notes-management-utility-bar-action-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, BATCH_ACTIONS)), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "notes-management-utility-bar-refresh-button",
    iconSide: "right",
    iconType: "refresh",
    onClick: refresh,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, REFRESH))));
});
NotesUtilityBar.displayName = 'NotesUtilityBar';