"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SupportedVersionForProtectionNotice = exports.NotifyUserOption = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _protection_notice_supported_endpoint_version = require("../protection_notice_supported_endpoint_version");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _empty_value = require("../../../../../../common/components/empty_value");
var _use_license = require("../../../../../../common/hooks/use_license");
var _setting_card = require("./setting_card");
var _types = require("../../../../../../../common/endpoint/types");
var _use_get_custom_notification_unavailable_component = require("../hooks/use_get_custom_notification_unavailable_component");
var _shared_translations = require("./shared_translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/notify_user_option.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NotifyUserOption = exports.NotifyUserOption = /*#__PURE__*/_react.default.memo(({
  policy,
  onChange,
  mode,
  protection,
  osList,
  'data-test-subj': dataTestSubj
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const CustomNotificationUpsellingComponent = (0, _use_get_custom_notification_unavailable_component.useGetCustomNotificationUnavailableComponent)();
  const isEditMode = mode === 'edit';
  const selected = policy.windows[protection].mode;
  const userNotificationSelected = policy.windows.popup[protection].enabled;
  const userNotificationMessage = policy.windows.popup[protection].message;
  const handleUserNotificationCheckbox = (0, _react.useCallback)(event => {
    const newPayload = (0, _lodash.cloneDeep)(policy);
    for (const os of osList) {
      if (os === 'windows') {
        newPayload[os].popup[protection].enabled = event.target.checked;
      } else if (os === 'mac') {
        newPayload[os].popup[protection].enabled = event.target.checked;
      } else if (os === 'linux') {
        newPayload[os].popup[protection].enabled = event.target.checked;
      }
    }
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [policy, onChange, osList, protection]);
  const handleCustomUserNotification = (0, _react.useCallback)(event => {
    const newPayload = (0, _lodash.cloneDeep)(policy);
    for (const os of osList) {
      if (os === 'windows') {
        newPayload[os].popup[protection].message = event.target.value;
      } else if (os === 'mac') {
        newPayload[os].popup[protection].message = event.target.value;
      } else if (os === 'linux') {
        newPayload[os].popup[protection].message = event.target.value;
      }
    }
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [policy, onChange, osList, protection]);
  const tooltipProtectionText = (0, _react.useCallback)(protectionType => {
    if (protectionType === 'memory_protection') {
      return _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.memoryProtectionTooltip', {
        defaultMessage: 'memory threat'
      });
    } else if (protectionType === 'behavior_protection') {
      return _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.behaviorProtectionTooltip', {
        defaultMessage: 'malicious behavior'
      });
    } else {
      return protectionType;
    }
  }, []);
  const tooltipBracketText = (0, _react.useCallback)(protectionType => {
    if (protectionType === 'memory_protection' || protection === 'behavior_protection') {
      return _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.rule', {
        defaultMessage: 'rule'
      });
    } else {
      return _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.filename', {
        defaultMessage: 'filename'
      });
    }
  }, [protection]);
  const customNotificationComponent = (0, _react.useMemo)(() => {
    if (!userNotificationSelected) {
      return null;
    }
    if (CustomNotificationUpsellingComponent) {
      return /*#__PURE__*/_react.default.createElement(CustomNotificationUpsellingComponent, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 16
        }
      });
    }
    if (!isEditMode) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h4", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 15
        }
      }, _shared_translations.NOTIFICATION_MESSAGE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, userNotificationMessage || (0, _empty_value.getEmptyValue)()));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": getTestId('customMessageTitle'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 17
      }
    }, _shared_translations.CUSTOMIZE_NOTIFICATION_MESSAGE_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      "data-test-subj": getTestId('tooltipInfo'),
      anchorProps: {
        'data-test-subj': getTestId('tooltipIcon')
      },
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policyDetailsConfig.notifyUserTooltip.a",
        defaultMessage: "Selecting the user notification option will display a notification to the host user when { protectionName } is prevented or detected.",
        values: {
          protectionName: tooltipProtectionText(protection)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 21
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 21
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policyDetailsConfig.notifyUserTooltip.c",
        defaultMessage: " The user notification can be customized in the text box below. Bracketed tags can be used to dynamically populate the applicable action (such as prevented or detected) and the { bracketText }.",
        values: {
          bracketText: tooltipBracketText(protection)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 21
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      placeholder: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetails.userNotification.placeholder', {
        defaultMessage: 'Input your custom notification message'
      }),
      value: userNotificationMessage,
      onChange: handleCustomUserNotification,
      fullWidth: true,
      disabled: !isEditMode,
      "data-test-subj": getTestId('customMessage'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 11
      }
    }));
  }, [CustomNotificationUpsellingComponent, getTestId, handleCustomUserNotification, isEditMode, protection, tooltipBracketText, tooltipProtectionText, userNotificationMessage, userNotificationSelected]);
  if (!isPlatinumPlus) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_setting_card.SettingCardHeader, {
    "data-test-subj": getTestId('title'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  }, _shared_translations.NOTIFY_USER_SECTION_TITLE), /*#__PURE__*/_react.default.createElement(SupportedVersionForProtectionNotice, {
    protection: protection,
    "data-test-subj": getTestId('supportedVersion'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": getTestId('checkbox'),
    id: `${protection}UserNotificationCheckbox}`,
    onChange: handleUserNotificationCheckbox,
    checked: userNotificationSelected,
    disabled: !isEditMode || selected === _types.ProtectionModes.off,
    label: _shared_translations.NOTIFY_USER_CHECKBOX_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }), customNotificationComponent);
});
NotifyUserOption.displayName = 'NotifyUserOption';
const SupportedVersionForProtectionNotice = exports.SupportedVersionForProtectionNotice = /*#__PURE__*/_react.default.memo(({
  protection,
  'data-test-subj': dataTestSubj
}) => {
  const version = (0, _react.useMemo)(() => {
    return _protection_notice_supported_endpoint_version.PROTECTION_NOTICE_SUPPORTED_ENDPOINT_VERSION[protection];
  }, [protection]);
  if (!version) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("i", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetails.supportedVersion",
    defaultMessage: "Agent version {version}",
    values: {
      version
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 11
    }
  })));
});
SupportedVersionForProtectionNotice.displayName = 'SupportedVersionForProtectionNotice';