"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointDetailsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _hooks = require("../hooks");
var _selectors = require("../../store/selectors");
var _routing = require("../../../../common/routing");
var _endpoint_details = require("./endpoint_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EndpointDetailsFlyout = exports.EndpointDetailsFlyout = /*#__PURE__*/(0, _react.memo)(() => {
  const history = (0, _reactRouterDom.useHistory)();
  const queryParams = (0, _hooks.useEndpointSelector)(_selectors.uiQueryParams);
  const {
    selected_endpoint: selectedEndpoint,
    ...queryParamsWithoutSelectedEndpoint
  } = queryParams;
  const handleFlyoutClose = (0, _react.useCallback)(() => {
    const {
      show: _show,
      ...urlSearchParams
    } = queryParamsWithoutSelectedEndpoint;
    history.push((0, _routing.getEndpointListPath)({
      name: 'endpointList',
      ...urlSearchParams
    }));
  }, [history, queryParamsWithoutSelectedEndpoint]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: handleFlyoutClose,
    "data-test-subj": "endpointDetailsFlyout",
    size: "m",
    paddingSize: "l",
    ownFocus: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_endpoint_details.EndpointDetails, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }));
});
EndpointDetailsFlyout.displayName = 'EndpointDetailsFlyout';