"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetPendingActions = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../../../common/endpoint/constants");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Request parameters for pending actions API
 */

/**
 * Error type for pending actions API errors
 */

/**
 * Hook to retrieve pending response actions for cancellation
 * Uses the standard actions list endpoint with pending status filter
 * @param params - Query parameters including agentType, endpointId, etc.
 * @param options - Additional options for the query
 * @returns Query result containing pending actions data
 */
const useGetPendingActions = (params, options = {}) => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-pending-actions', params],
    queryFn: async () => {
      return http.get(_constants.BASE_ENDPOINT_ACTION_ROUTE, {
        version: '2023-10-31',
        query: {
          agentIds: params.endpointId ? [params.endpointId] : undefined,
          agentTypes: params.agentType ? [params.agentType] : undefined,
          commands: params.commands,
          page: params.page,
          pageSize: params.pageSize,
          statuses: ['pending'] // Filter for pending actions only
        }
      });
    },
    ...options
  });
};
exports.useGetPendingActions = useGetPendingActions;