"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicySelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/fleet-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/fleet-plugin/public");
var _i18n = require("@kbn/i18n");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _react2 = require("@emotion/react");
var _use_fetch_policy_data = require("./hooks/use_fetch_policy_data");
var _common2 = require("../../../../common");
var _kibana = require("../../../common/lib/kibana");
var _endpoint = require("../../../common/components/endpoint");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _routing = require("../../common/routing");
var _user_privileges = require("../../../common/components/user_privileges");
var _empty_value = require("../../../common/components/empty_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/policy_selector/policy_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NOOP = () => {};
const PolicySelectorContainer = _styled.default.div`
  .header-container {
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
  }

  .body-container {
    position: relative;
    border-top: none;
    border-bottom: none;
    border-radius: 0;
  }

  .footer-container {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
  }

  .list-container {
    height: ${props => {
  var _props$height;
  return (_props$height = props.height) !== null && _props$height !== void 0 ? _props$height : '225px';
}};
    position: relative;
  }

  .searchbar {
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
  }

  .policy-name .euiSelectableListItem__text {
    text-decoration: none !important;
    color: ${({
  theme
}) => theme.euiTheme.colors.textParagraph} !important;
  }

  .euiSelectableList {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
    border-top-width: 0;
  }

  .border-right {
    border-right: ${({
  theme
}) => theme.euiTheme.border.thin};
    padding-right: ${({
  theme
}) => theme.euiTheme.size.s};
  }
`;
/**
 * Provides a component that displays a list of policies fetched from Fleet, which the user can
 * select and unselect. By default, it queries Fleet for Elastic Defend policies, but that can be
 * configured via `queryOptions.kuery`, thus it can display any type of Fleet integration policies
 */
const PolicySelector = exports.PolicySelector = /*#__PURE__*/(0, _react.memo)(({
  queryOptions: {
    kuery = `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name: endpoint`,
    sortField = 'name',
    sortOrder = 'asc',
    withAgentCount = false,
    perPage = 20
  } = {},
  selectedPolicyIds,
  searchFields = ['name', 'description'],
  onChange,
  onFetch,
  height,
  useCheckbox = false,
  showPolicyLink = false,
  policyDisplayOptions,
  singleSelection = false,
  additionalListItems = [],
  isDisabled = false,
  'data-test-subj': dataTestSubj
}) => {
  var _policyListResponse$t, _policyListResponse$p;
  const toasts = (0, _kibana.useToasts)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const {
    canReadPolicyManagement,
    canWriteIntegrationPolicies
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const [page, setPage] = (0, _react.useState)(1);
  const [selectedListPage, setSelectedListPage] = (0, _react.useState)(1);
  const [userSearchValue, setUserSearchValue] = (0, _react.useState)('');
  const [searchKuery, setSearchKuery] = (0, _react.useState)(kuery);
  const [view, setView] = (0, _react.useState)('full-list');
  const reactWindowFixedSizeList = (0, _react.useRef)();
  const handledApiData = (0, _react.useRef)(new WeakSet());

  // Delays setting the `searchKuery` value thus allowing the user to pause typing - so
  // that we don't call the API on every character change.
  (0, _useDebounce.default)(() => {
    setPage(1);
    if (userSearchValue) {
      const kueryWithSearchValue = searchFields.map(field => `(${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.${field}:*${userSearchValue}*)`).join(' OR ');
      if (kuery) {
        setSearchKuery(`(${kuery}) AND (${kueryWithSearchValue})`);
        return;
      }
      setSearchKuery(kueryWithSearchValue);
      return;
    }
    setSearchKuery(kuery);
  }, 300, [userSearchValue, kuery]);
  const {
    data: policyListResponse,
    isFetching,
    isLoading,
    error
  } = (0, _use_fetch_policy_data.useFetchPolicyData)({
    kuery: searchKuery,
    sortOrder,
    sortField,
    perPage,
    withAgentCount,
    page: view === 'full-list' ? page : selectedListPage
  }, selectedPolicyIds, view);

  // Store the initial unfiltered total count for consistent display
  const [unfilteredTotalCount, setUnfilteredTotalCount] = (0, _react.useState)(null);
  const selectedCount = (0, _react.useMemo)(() => {
    return selectedPolicyIds.length + additionalListItems.filter(item => item.checked === 'on').length;
  }, [additionalListItems, selectedPolicyIds.length]);

  // Set the unfiltered total count when we first get data without search
  (0, _react.useEffect)(() => {
    if (policyListResponse && !userSearchValue && unfilteredTotalCount === null) {
      setUnfilteredTotalCount(policyListResponse.total);
    }
  }, [policyListResponse, userSearchValue, unfilteredTotalCount]);
  const totalItems = (0, _react.useMemo)(() => {
    var _ref, _additionalListItems$;
    // Use stored unfiltered total when available, otherwise fall back to current total
    const baseTotalCount = (_ref = unfilteredTotalCount !== null && unfilteredTotalCount !== void 0 ? unfilteredTotalCount : policyListResponse === null || policyListResponse === void 0 ? void 0 : policyListResponse.total) !== null && _ref !== void 0 ? _ref : 0;
    // Count only selectable additional items, excluding group labels
    const selectableAdditionalItems = (_additionalListItems$ = additionalListItems === null || additionalListItems === void 0 ? void 0 : additionalListItems.filter(item => !item.isGroupLabel).length) !== null && _additionalListItems$ !== void 0 ? _additionalListItems$ : 0;
    return baseTotalCount + selectableAdditionalItems;
  }, [additionalListItems, policyListResponse === null || policyListResponse === void 0 ? void 0 : policyListResponse.total, unfilteredTotalCount]);

  // @ts-expect-error EUI does not seem to have correctly types the `windowProps` which come from React-Window `FixedSizeList` component
  const listProps = (0, _react.useMemo)(() => {
    return {
      bordered: false,
      showIcons: !useCheckbox,
      windowProps: {
        ref: reactWindowFixedSizeList
      }
    };
  }, [useCheckbox]);

  // The full list of items (options) that will be displayed in the EuiSelectable. This includes both
  // items from the API results as well as any "additionalListItems" passed in to the component
  const selectableOptions = (0, _react.useMemo)(() => {
    if (!policyListResponse) {
      return [];
    }
    const isPolicySelected = new Set(selectedPolicyIds);
    const buildLinkToApp = policy => {
      var _policy$package;
      if (!showPolicyLink) {
        return null;
      }
      const isEndpointPolicy = ((_policy$package = policy.package) === null || _policy$package === void 0 ? void 0 : _policy$package.name) === 'endpoint';
      if (isEndpointPolicy && !canReadPolicyManagement || !canWriteIntegrationPolicies) {
        return null;
      }
      const appId = isEndpointPolicy ? _common2.APP_UI_ID : _common.INTEGRATIONS_PLUGIN_ID;
      const urlPath = isEndpointPolicy ? (0, _routing.getPolicyDetailPath)(policy.id) : _public.pagePathGetters.integration_policy_edit({
        packagePolicyId: policy.id
      })[1];
      return /*#__PURE__*/_react.default.createElement(_endpoint.LinkToApp, {
        href: getAppUrl({
          path: urlPath,
          appId
        }),
        appPath: urlPath,
        target: "_blank",
        "data-test-subj": getTestId(`policy-${policy.id}-policyLink`),
        onClick: event => {
          event.stopPropagation();
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 325,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.effectedPolicySelect.viewPolicyLinkLabel",
        defaultMessage: "View policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 334,
          columnNumber: 13
        }
      }));
    };
    return policyListResponse.items.map(policy => {
      var _customDisplayOptions;
      const customDisplayOptions = policyDisplayOptions ? policyDisplayOptions(policy) : {};
      return {
        disabled: isDisabled,
        ...customDisplayOptions,
        label: policy.name,
        className: 'policy-name',
        'data-test-subj': getTestId(`policy-${policy.id}`),
        policy,
        checked: isPolicySelected.has(policy.id) ? 'on' : undefined,
        prepend: useCheckbox ? /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
          id: (0, _eui.htmlIdGenerator)()(),
          onChange: NOOP,
          checked: isPolicySelected.has(policy.id),
          disabled: (_customDisplayOptions = customDisplayOptions.disabled) !== null && _customDisplayOptions !== void 0 ? _customDisplayOptions : isDisabled,
          "data-test-subj": getTestId(`policy-${policy.id}-checkbox`),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 357,
            columnNumber: 15
          }
        }) : undefined,
        append: showPolicyLink ? buildLinkToApp(policy) : null
      };
    }).concat(...additionalListItems.filter(additionalItem => additionalItem.isGroupLabel || !(view === 'selected-list' && additionalItem.checked !== 'on')).map(additionalItem => {
      var _additionalItem$disab, _additionalItem$data;
      return {
        disabled: isDisabled,
        ...additionalItem,
        'data-type': 'customItem',
        prepend: useCheckbox && !additionalItem.isGroupLabel ? /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
          id: (0, _eui.htmlIdGenerator)()(),
          onChange: NOOP,
          checked: additionalItem.checked === 'on',
          disabled: (_additionalItem$disab = additionalItem.disabled) !== null && _additionalItem$disab !== void 0 ? _additionalItem$disab : isDisabled,
          "data-test-subj": getTestId(`${(_additionalItem$data = additionalItem['data-test-subj']) !== null && _additionalItem$data !== void 0 ? _additionalItem$data : 'additionalItem'}-checkbox`),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 382,
            columnNumber: 21
          }
        }) : null
      };
    }));
  }, [additionalListItems, canReadPolicyManagement, canWriteIntegrationPolicies, getAppUrl, getTestId, isDisabled, policyDisplayOptions, policyListResponse, selectedPolicyIds, showPolicyLink, useCheckbox, view]);
  const noPoliciesFoundEmptyState = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 413,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 415,
          columnNumber: 20
        }
      }, 'No policies found'),
      titleSize: "s",
      paddingSize: "m",
      color: "subdued",
      "data-test-subj": getTestId('noPolicies'),
      body: userSearchValue ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 422,
          columnNumber: 17
        }
      }, 'Your search criteria did not match any policy') : null,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 414,
        columnNumber: 11
      }
    }));
  }, [getTestId, userSearchValue]);
  const isCustomOption = (0, _react.useCallback)(option => {
    // @ts-expect-error
    return option['data-type'] === 'customItem';
  }, []);
  const getUpdatedAdditionalListItems = (0, _react.useCallback)((updatedItem, listOfAdditionalItems) => {
    return listOfAdditionalItems.map(item => {
      if (item.label === updatedItem.label) {
        return {
          ...item,
          checked: updatedItem.checked
        };
      }
      return item;
    });
  }, []);
  const listBuilderCallback = (0, _react.useCallback)((list, _search) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, list);
  }, []);
  const getUpdatedSelectedPolicyIds = (0, _react.useCallback)((addToList, removeFromList) => {
    return Array.from(new Set(selectedPolicyIds.filter(id => !removeFromList.includes(id)).concat(...addToList)));
  }, [selectedPolicyIds]);
  const handleOnPolicySelectChange = (0, _react.useCallback)((_updatedOptions, _ev, changedOption) => {
    const isChangedOptionCustom = isCustomOption(changedOption);
    const updatedPolicyIds = !isChangedOptionCustom ? changedOption.checked === 'on' ? selectedPolicyIds.concat(changedOption.policy.id) : selectedPolicyIds.filter(id => id !== changedOption.policy.id) : selectedPolicyIds;
    const updatedAdditionalItems = isChangedOptionCustom ? getUpdatedAdditionalListItems(changedOption, additionalListItems) : additionalListItems;
    return onChange(updatedPolicyIds, updatedAdditionalItems);
  }, [additionalListItems, getUpdatedAdditionalListItems, isCustomOption, onChange, selectedPolicyIds]);
  const onPageClickHandler = (0, _react.useCallback)(activePage => {
    if (view === 'selected-list') {
      setSelectedListPage(activePage + 1);
    } else {
      setPage(activePage + 1);
    }
  }, [view]);
  const onSearchHandler = (0, _react.useCallback)(updatedSearchValue => {
    setUserSearchValue(updatedSearchValue);
  }, []);
  const onSearchInputChangeHandler = (0, _react.useCallback)(ev => {
    setUserSearchValue(ev.target.value);
  }, []);
  const viewSelectedOnClickHandler = (0, _react.useCallback)(() => {
    setView(prevState => prevState === 'selected-list' ? 'full-list' : 'selected-list');
  }, []);
  const onSelectUnselectAllClickHandler = (0, _react.useCallback)(ev => {
    const isSelectAll = ev.currentTarget.value === 'selectAll';
    const policiesToSelect = [];
    const policiesToUnSelect = [];
    let updatedAdditionalItems = additionalListItems;
    for (const option of selectableOptions) {
      // only select/unselect items that are not disabled and not a group label item
      if (!option.disabled && !option.isGroupLabel) {
        if (isSelectAll) {
          if (!isCustomOption(option)) {
            policiesToSelect.push(option.policy.id);
          } else {
            updatedAdditionalItems = getUpdatedAdditionalListItems({
              ...option,
              checked: 'on'
            }, updatedAdditionalItems);
          }
        } else {
          if (!isCustomOption(option)) {
            policiesToUnSelect.push(option.policy.id);
          } else {
            updatedAdditionalItems = getUpdatedAdditionalListItems({
              ...option,
              checked: undefined
            }, updatedAdditionalItems);
          }
        }
      }
    }
    onChange(getUpdatedSelectedPolicyIds(policiesToSelect, policiesToUnSelect), updatedAdditionalItems);
  }, [additionalListItems, getUpdatedAdditionalListItems, getUpdatedSelectedPolicyIds, isCustomOption, onChange, selectableOptions]);

  // Show API errors when they are encountered
  (0, _react.useEffect)(() => {
    if (error) {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.securitySolution.policySelector.apiFetchErrorToastTitle', {
          defaultMessage: 'Failed to fetch list of policies'
        }),
        toastMessage: error.body ? JSON.stringify(error.body) : undefined
      });
    }
  }, [toasts, error]);

  // When viewing Selected Policies, if they are all "un-selected", then set the view back to 'full-list'
  (0, _react.useEffect)(() => {
    if (view === 'selected-list' && selectedCount === 0) {
      setView('full-list');
    }
  }, [selectedCount, view]);

  // Everytime the `data` changes:
  //    1. scroll list back up to the top
  //    2. call `onFetch()` if defined
  (0, _react.useEffect)(() => {
    if (policyListResponse && !isFetching && !handledApiData.current.has(policyListResponse)) {
      handledApiData.current.add(policyListResponse);
      if (reactWindowFixedSizeList.current) {
        reactWindowFixedSizeList.current.scrollToItem(0);
      }
      if (onFetch) {
        onFetch({
          type: view === 'selected-list' ? 'selected' : 'search',
          filtered: Boolean(userSearchValue),
          data: policyListResponse
        });
      }
    }
  }, [isFetching, onFetch, policyListResponse, userSearchValue, view]);
  return /*#__PURE__*/_react.default.createElement(PolicySelectorContainer, {
    "data-test-subj": dataTestSubj,
    height: height,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 618,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    hasBorder: true,
    className: "header-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 619,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 620,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 621,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: view === 'selected-list' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.policySelector.searchbarTooltipMessage",
      defaultMessage: "Search is not available when viewing selected policies",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 625,
        columnNumber: 21
      }
    }) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 622,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    placeholder: _i18n.i18n.translate('xpack.securitySolution.policySelector.searchbarPlaceholder', {
      defaultMessage: 'Search policies'
    }),
    value: userSearchValue,
    onSearch: onSearchHandler,
    onChange: onSearchInputChangeHandler,
    incremental: false,
    disabled: isDisabled || view === 'selected-list',
    "data-test-subj": getTestId('searchbar'),
    isClearable: true,
    fullWidth: true,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 632,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 649,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "filter",
    size: "s",
    onClick: viewSelectedOnClickHandler,
    disabled: selectedCount === 0,
    fill: view === 'selected-list',
    "data-test-subj": getTestId('viewSelectedButton'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 650,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.policySelector.selectedButton",
    defaultMessage: "Selected",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 658,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    hasBorder: true,
    className: "body-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 667,
      columnNumber: 9
    }
  }, isFetching && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    "data-test-subj": getTestId('isFetching'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 669,
      columnNumber: 13
    }
  }), selectableOptions.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xs",
    hasShadow: false,
    hasBorder: false,
    css: (0, _react2.css)`
                padding-top: 0 !important;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 678,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 686,
      columnNumber: 15
    }
  }, view === 'full-list' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "border-right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 688,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.policySelector.selectAllTooltipMessage",
      defaultMessage: "Select all displayed in current page",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 691,
        columnNumber: 25
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 689,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    value: "selectAll",
    onClick: onSelectUnselectAllClickHandler,
    "data-test-subj": getTestId('selectAllButton'),
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 697,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.policySelector.selectAll",
    defaultMessage: "Select all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 704,
      columnNumber: 25
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 712,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.policySelector.unSelectAllTooltipMessage",
      defaultMessage: "Un-select all in current page",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 715,
        columnNumber: 23
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 713,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    value: "unSelectAll",
    onClick: onSelectUnselectAllClickHandler,
    "data-test-subj": getTestId('unselectAllButton'),
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 721,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.policySelector.unSelectAll",
    defaultMessage: "Un-select all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 728,
      columnNumber: 23
    }
  })))))), /*#__PURE__*/_react.default.createElement("div", {
    className: "list-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 739,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: selectableOptions,
    listProps: listProps,
    onChange: handleOnPolicySelectChange,
    searchable: false,
    singleSelection: singleSelection,
    isLoading: isLoading,
    height: "full",
    "data-test-subj": getTestId('list'),
    emptyMessage: noPoliciesFoundEmptyState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 740,
      columnNumber: 13
    }
  }, listBuilderCallback))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    hasBorder: true,
    className: "footer-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 756,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "center",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 757,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "border-right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 758,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": getTestId('policyFetchTotal'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 759,
      columnNumber: 15
    }
  }, view === 'selected-list' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.policySelector.totalSelected",
    defaultMessage: "{selectedCount} selected",
    values: {
      selectedCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 761,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.policySelector.totalPoliciesFound",
    defaultMessage: "{selectedCount} of {count} selected",
    values: {
      selectedCount,
      count: totalItems
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 767,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 778,
      columnNumber: 13
    }
  }, policyListResponse && policyListResponse.total > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.policySelector.policyListPagination', {
      defaultMessage: 'Policy list pagination'
    }),
    pageCount: Math.ceil(((_policyListResponse$t = policyListResponse === null || policyListResponse === void 0 ? void 0 : policyListResponse.total) !== null && _policyListResponse$t !== void 0 ? _policyListResponse$t : 0) / perPage),
    activePage: ((_policyListResponse$p = policyListResponse === null || policyListResponse === void 0 ? void 0 : policyListResponse.page) !== null && _policyListResponse$p !== void 0 ? _policyListResponse$p : 1) - 1,
    onPageClick: onPageClickHandler,
    "data-test-subj": getTestId('pagination'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 780,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "textSu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 791,
      columnNumber: 17
    }
  }, (0, _empty_value.getEmptyTagValue)())))));
});
PolicySelector.displayName = 'PolicySelector';