"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionSuccess = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _endpoint_action_response_codes = require("../lib/endpoint_action_response_codes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/components/action_success.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Display generic success message for all actions
 */
const ActionSuccess = exports.ActionSuccess = /*#__PURE__*/(0, _react.memo)(({
  action,
  ResultComponent,
  title: _title,
  ...props
}) => {
  const title = (0, _react.useMemo)(() => {
    var _action$outputs, _action$outputs$first, _action$outputs$first2;
    if (_title) {
      return _title;
    }
    const firstAgentId = action.agents[0];
    const actionOutputCode = (_action$outputs = action.outputs) === null || _action$outputs === void 0 ? void 0 : (_action$outputs$first = _action$outputs[firstAgentId]) === null || _action$outputs$first === void 0 ? void 0 : (_action$outputs$first2 = _action$outputs$first.content) === null || _action$outputs$first2 === void 0 ? void 0 : _action$outputs$first2.code;
    return actionOutputCode ? _endpoint_action_response_codes.endpointActionResponseCodes[actionOutputCode] : undefined;
  }, [_title, action.agents, action.outputs]);
  return /*#__PURE__*/_react.default.createElement(ResultComponent, (0, _extends2.default)({}, props, {
    title: title,
    agentType: action.agentType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 12
    }
  }));
});
ActionSuccess.displayName = 'ActionSuccess';