"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POLICY_NOT_FOUND_MESSAGE = exports.EndpointPolicyLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_test_id_generator = require("../hooks/use_test_id_generator");
var _routing = require("../common/routing");
var _use_navigate_by_router_event_handler = require("../../common/hooks/endpoint/use_navigate_by_router_event_handler");
var _hooks = require("../../common/lib/kibana/hooks");
var _user_privileges = require("../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_policy_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const POLICY_NOT_FOUND_MESSAGE = exports.POLICY_NOT_FOUND_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.endpointPolicyLink.policyNotFound', {
  defaultMessage: 'Policy no longer available!'
});
/**
 * Will display the provided content (`children`) as a link that takes the user to the Endpoint
 * Policy Details page. A link is only displayed if the user has Authz to that page, otherwise the
 * provided display content will just be shown as is.
 */
const EndpointPolicyLink = exports.EndpointPolicyLink = /*#__PURE__*/(0, _react.memo)(({
  policyId,
  backLink,
  children,
  policyExists = true,
  isOutdated = false,
  tooltip = true,
  revision,
  textSize = 's',
  ...euiLinkProps
}) => {
  const {
    getAppUrl
  } = (0, _hooks.useAppUrl)();
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const testId = (0, _use_test_id_generator.useTestIdGenerator)(euiLinkProps['data-test-subj']);
  const {
    toRoutePath,
    toRouteUrl
  } = (0, _react.useMemo)(() => {
    const path = policyId ? (0, _routing.getPolicyDetailPath)(policyId) : '';
    return {
      toRoutePath: backLink ? {
        pathname: path,
        state: {
          backLink
        }
      } : path,
      toRouteUrl: getAppUrl({
        path
      })
    };
  }, [policyId, getAppUrl, backLink]);
  const clickHandler = (0, _use_navigate_by_router_event_handler.useNavigateByRouterEventHandler)(toRoutePath);
  const displayAsLink = (0, _react.useMemo)(() => {
    return Boolean(canReadPolicyManagement && policyId && policyExists);
  }, [canReadPolicyManagement, policyExists, policyId]);
  const displayValue = (0, _react.useMemo)(() => {
    const content = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      className: "eui-displayInline eui-textTruncate",
      size: textSize,
      "data-test-subj": testId('displayContent'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, children);
    return displayAsLink ?
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
      href: toRouteUrl,
      onClick: clickHandler
    }, euiLinkProps, {
      "data-test-subj": testId('link'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }), content) : content;
  }, [children, clickHandler, displayAsLink, euiLinkProps, testId, textSize, toRouteUrl]);
  const policyNoLongerAvailableMessage = (0, _react.useMemo)(() => {
    return (!policyId || !policyExists) && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      className: "eui-textNoWrap",
      "data-test-subj": testId('policyNotFoundMsg'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "warning",
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 13
      }
    }), "\xA0", POLICY_NOT_FOUND_MESSAGE) || null;
  }, [policyExists, policyId, testId]);
  const tooltipContent = (0, _react.useMemo)(() => {
    const content = tooltip === true ? children : tooltip || undefined;
    return content ? /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-textBreakAll",
      css: {
        width: '100%'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 9
      }
    }, content, policyNoLongerAvailableMessage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", `(${POLICY_NOT_FOUND_MESSAGE})`)) : content;
  }, [children, policyNoLongerAvailableMessage, tooltip]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: false,
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    "data-test-subj": testId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": testId('policyName'),
    className: "eui-textTruncate",
    grow: false,
    css: {
      minWidth: '40px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, tooltipContent ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent,
    anchorClassName: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 15
    }
  }, displayValue) : displayValue), revision && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    className: "eui-textTruncate",
    "data-test-subj": testId('revision'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpointPolicyLink.policyVersion",
    defaultMessage: "rev. {revision}",
    values: {
      revision
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 17
    }
  }))), isOutdated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "warning",
    color: "warning",
    className: "eui-alignTop",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-displayInlineBlock",
    "data-test-subj": testId('outdatedMsg'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpointPolicyLink.outdatedMessage",
    defaultMessage: "Out-of-date",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 19
    }
  }))))), policyNoLongerAvailableMessage);
});
EndpointPolicyLink.displayName = 'EndpointPolicyLink';