"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleInputAreaState = exports.INPUT_DEFAULT_PLACEHOLDER_TEXT = void 0;
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _parsed_command_input = require("../../../service/parsed_command_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INPUT_DEFAULT_PLACEHOLDER_TEXT = exports.INPUT_DEFAULT_PLACEHOLDER_TEXT = _i18n.i18n.translate('xpack.securitySolution.handleInputAreaState.inputPlaceholderText', {
  defaultMessage: 'Submit response action'
});
const setArgSelectorValueToParsedArgs = (parsedInput, enteredCommand) => {
  if (enteredCommand && enteredCommand.argsWithValueSelectors) {
    for (const argName of Object.keys(enteredCommand.argsWithValueSelectors)) {
      if (parsedInput.hasArg(argName)) {
        var _enteredCommand$argSt;
        const argumentValues = (_enteredCommand$argSt = enteredCommand.argState[argName]) !== null && _enteredCommand$argSt !== void 0 ? _enteredCommand$argSt : [];
        parsedInput.args[argName] = argumentValues.map(itemState => {
          return (itemState === null || itemState === void 0 ? void 0 : itemState.value) || '';
        });
      }
    }
  }
};
const handleInputAreaState = (state, {
  type,
  payload
}) => {
  var _payload$display;
  switch (type) {
    case 'updateInputPopoverState':
      if (state.input.showPopover !== payload.show) {
        return {
          ...state,
          input: {
            ...state.input,
            showPopover: payload.show
          }
        };
      }
      break;
    case 'updateInputHistoryState':
      return {
        ...state,
        input: {
          ...state.input,
          // Keeping the last 100 entries only for now
          history: [{
            id: (0, _uuid.v4)(),
            input: payload.command,
            display: (_payload$display = payload.display) !== null && _payload$display !== void 0 ? _payload$display : payload.command,
            // We only store the `value` and `valueText`. `store` property of each argument's state
            // is component instance specific data.
            argState: Object.entries(payload.argState || {}).reduce((acc, [argName, argValuesState]) => {
              acc[argName] = argValuesState.map(({
                value,
                valueText
              }) => {
                return {
                  value,
                  valueText
                };
              });
              return acc;
            }, {})
          }, ...state.input.history.slice(0, 99)]
        }
      };
    case 'clearInputHistoryState':
      return {
        ...state,
        input: {
          ...state.input,
          history: []
        }
      };
    case 'updateInputTextEnteredState':
      const {
        leftOfCursorText: newTextEntered,
        rightOfCursorText: newRightOfCursor = '',
        argState: adjustedArgState
      } = typeof payload === 'function' ? payload(state.input) : payload;
      if (state.input.leftOfCursorText !== newTextEntered || state.input.rightOfCursorText !== newRightOfCursor) {
        var _enteredCommand;
        const parsedInput = (0, _parsed_command_input.parseCommandInput)(newTextEntered + newRightOfCursor);
        let enteredCommand = state.input.enteredCommand;
        if (enteredCommand && adjustedArgState && ((_enteredCommand = enteredCommand) === null || _enteredCommand === void 0 ? void 0 : _enteredCommand.argState) !== adjustedArgState) {
          enteredCommand = {
            ...enteredCommand,
            argState: adjustedArgState
          };
        }

        // Determine if `enteredCommand` should be re-defined
        if (parsedInput.name && (!enteredCommand || parsedInput.name !== enteredCommand.commandDefinition.name) || !parsedInput.name && enteredCommand) {
          enteredCommand = undefined;
          const commandDefinition = state.commands.find(def => def.name === parsedInput.name);
          if (commandDefinition) {
            let argsWithValueSelectors;
            const argState = adjustedArgState !== null && adjustedArgState !== void 0 ? adjustedArgState : {};
            for (const [argName, argDef] of Object.entries((_commandDefinition$ar = commandDefinition.args) !== null && _commandDefinition$ar !== void 0 ? _commandDefinition$ar : {})) {
              var _commandDefinition$ar;
              if (argDef.SelectorComponent) {
                var _parsedInput$args$arg, _argState$argName;
                if (!argsWithValueSelectors) {
                  argsWithValueSelectors = {};
                }
                argsWithValueSelectors[argName] = argDef;

                // Clear selector argument values for clean commands (e.g., from history)
                // This ensures specific selectors start fresh instead of showing old values - when command argument contains selectorShowTextValue set to true
                // BUT: Don't clear if we already have values from preprocessing (paste, history, etc.)
                if (parsedInput.hasArg(argName) && (_parsedInput$args$arg = parsedInput.args[argName]) !== null && _parsedInput$args$arg !== void 0 && _parsedInput$args$arg.includes(true) && !((_argState$argName = argState[argName]) !== null && _argState$argName !== void 0 && _argState$argName.length)) {
                  argState[argName] = [];
                }
              }
            }
            enteredCommand = {
              argState,
              commandDefinition,
              argsWithValueSelectors
            };
          }
        }

        // Update parsed input with any values that were selected via argument selectors
        setArgSelectorValueToParsedArgs(parsedInput, enteredCommand);

        // Use original text values for display
        const displayLeftText = newTextEntered;
        const displayRightText = newRightOfCursor;
        return {
          ...state,
          input: {
            ...state.input,
            leftOfCursorText: displayLeftText,
            rightOfCursorText: displayRightText,
            parsedInput,
            enteredCommand
          }
        };
      }
      break;
    case 'updateInputPlaceholderState':
      if (state.input.placeholder !== payload.placeholder) {
        return {
          ...state,
          input: {
            ...state.input,
            placeholder: payload.placeholder || INPUT_DEFAULT_PLACEHOLDER_TEXT
          }
        };
      }
      break;
    case 'setInputState':
      if (state.input.visibleState !== payload.value) {
        return {
          ...state,
          input: {
            ...state.input,
            visibleState: payload.value
          }
        };
      }
      break;
    case 'updateInputCommandArgState':
      if (state.input.enteredCommand) {
        var _state$input$enteredC;
        const {
          name: argName,
          instance: argInstance,
          state: newArgState
        } = payload;
        const updatedArgState = [...((_state$input$enteredC = state.input.enteredCommand.argState[argName]) !== null && _state$input$enteredC !== void 0 ? _state$input$enteredC : [])];
        updatedArgState[argInstance] = newArgState;
        const updatedEnteredCommand = {
          ...state.input.enteredCommand,
          argState: {
            ...state.input.enteredCommand.argState,
            [argName]: updatedArgState
          }
        };

        // store a new version of parsed input that contains the updated selector value
        const updatedParsedInput = (0, _parsed_command_input.parseCommandInput)(state.input.leftOfCursorText + state.input.rightOfCursorText);
        setArgSelectorValueToParsedArgs(updatedParsedInput, updatedEnteredCommand);
        return {
          ...state,
          input: {
            ...state.input,
            parsedInput: updatedParsedInput,
            enteredCommand: updatedEnteredCommand
          }
        };
      }
      break;
  }

  // No updates needed. Just return original state
  return state;
};
exports.handleInputAreaState = handleInputAreaState;