"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOnExpandableFlyoutClose = void 0;
var _react = require("react");
var _use_which_flyout = require("../../document_details/shared/hooks/use_which_flyout");
var _flyouts = require("../../document_details/shared/constants/flyouts");
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to abstract the logic of listening to the onClose event for the Security Solution application.
 * The expandable-flyout package provides the onClose callback, but has there are only 2 instances of the expandable flyout in Security Solution (normal and timeline)
 * we need a way to propagate the onClose event to all other components.
 * 2 event names are available, we pick the correct one depending on which flyout is open (if the timeline flyout is open, it is always on top, so we choose that one).
 */
const useOnExpandableFlyoutClose = ({
  callback
}) => {
  const flyout = (0, _use_which_flyout.useWhichFlyout)();
  const eventName = flyout === _flyouts.Flyouts.securitySolution ? _.SECURITY_SOLUTION_ON_CLOSE_EVENT : _.TIMELINE_ON_CLOSE_EVENT;
  const eventHandler = (0, _react.useCallback)(e => callback(e.detail), [callback]);
  (0, _react.useEffect)(() => {
    window.addEventListener(eventName, eventHandler);
    return () => window.removeEventListener(eventName, eventHandler);
  }, [eventHandler, eventName]);
};
exports.useOnExpandableFlyoutClose = useOnExpandableFlyoutClose;