"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertHighlightedFieldsToTableRow = exports.convertHighlightedFieldsToPrevalenceFilters = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Converts the highlighted fields to a format that can be consumed by the HighlightedFields component
 * @param highlightedFields field/value pairs
 * @param scopeId used in the alerts page for CellActions
 * @param isPreview used in the alerts page for CellActions and also to hide PreviewLinks
 * @param showCellActions used in alert summary page to hide CellActions entirely
 */
const convertHighlightedFieldsToTableRow = (highlightedFields, scopeId, showCellActions, ancestorsIndexName) => {
  const fieldNames = Object.keys(highlightedFields);
  return fieldNames.map(fieldName => {
    var _highlightedFields$fi, _highlightedFields$fi2;
    const overrideFieldName = (_highlightedFields$fi = highlightedFields[fieldName].overrideField) === null || _highlightedFields$fi === void 0 ? void 0 : _highlightedFields$fi.field;
    const overrideFieldValues = (_highlightedFields$fi2 = highlightedFields[fieldName].overrideField) === null || _highlightedFields$fi2 === void 0 ? void 0 : _highlightedFields$fi2.values;
    const field = overrideFieldName ? overrideFieldName : fieldName;
    const values = overrideFieldValues !== null && overrideFieldValues !== void 0 && overrideFieldValues.length ? overrideFieldValues : highlightedFields[fieldName].values;
    return {
      field,
      description: {
        field,
        ...(overrideFieldName ? {
          originalField: fieldName
        } : {}),
        values,
        scopeId,
        showCellActions,
        ancestorsIndexName
      }
    };
  });
};

/**
 * Converts the highlighted fields to a format that can be consumed by the prevalence query
 * @param highlightedFields
 */
exports.convertHighlightedFieldsToTableRow = convertHighlightedFieldsToTableRow;
const convertHighlightedFieldsToPrevalenceFilters = highlightedFields => {
  const fieldNames = Object.keys(highlightedFields);
  return fieldNames.reduce((acc, curr) => {
    const values = highlightedFields[curr].values;
    return {
      ...acc,
      [curr]: {
        terms: {
          [curr]: values
        }
      }
    };
  }, []);
};
exports.convertHighlightedFieldsToPrevalenceFilters = convertHighlightedFieldsToPrevalenceFilters;