"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkRoutes = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _network = require("../../../../../common/search_strategy/security_solution/network");
var _ = require(".");
var _events_tab = require("../../../../common/components/events_tab");
var _anomalies_network_table = require("../../../../common/components/ml/tables/anomalies_network_table");
var _utils = require("../../../../common/components/visualization_actions/utils");
var _anomalies_query_tab_body = require("../../../../common/containers/anomalies/anomalies_query_tab_body");
var _conditional_flex_group = require("./conditional_flex_group");
var _types = require("./types");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/pages/navigation/network_routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NetworkRoutes = exports.NetworkRoutes = /*#__PURE__*/_react.default.memo(({
  type,
  to,
  filterQuery,
  isInitializing,
  from,
  indexNames,
  setQuery
}) => {
  const networkAnomaliesFilterQuery = {
    bool: {
      should: [{
        exists: {
          field: 'source.ip'
        }
      }, {
        exists: {
          field: 'destination.ip'
        }
      }],
      minimum_should_match: 1
    }
  };
  const commonProps = {
    startDate: from,
    endDate: to,
    indexNames,
    skip: isInitializing,
    type,
    setQuery,
    filterQuery
  };
  const tabProps = {
    ...commonProps
  };
  const anomaliesProps = {
    ...commonProps,
    anomaliesFilterQuery: networkAnomaliesFilterQuery,
    AnomaliesTableComponent: _anomalies_network_table.AnomaliesNetworkTable
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/:tabName(${_types.NetworkRouteType.dns})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_.DnsQueryTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/:tabName(${_types.NetworkRouteType.flows})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_conditional_flex_group.ConditionalFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_.IPsQueryTabBody, (0, _extends2.default)({}, tabProps, {
    flowTarget: _network.FlowTargetSourceDest.source,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_.IPsQueryTabBody, (0, _extends2.default)({}, tabProps, {
    flowTarget: _network.FlowTargetSourceDest.destination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_conditional_flex_group.ConditionalFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_.CountriesQueryTabBody, (0, _extends2.default)({}, tabProps, {
    flowTarget: _network.FlowTargetSourceDest.source,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_.CountriesQueryTabBody, (0, _extends2.default)({}, tabProps, {
    flowTarget: _network.FlowTargetSourceDest.destination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/:tabName(${_types.NetworkRouteType.http})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_.HttpQueryTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/:tabName(${_types.NetworkRouteType.tls})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_.TlsQueryTabBody, (0, _extends2.default)({}, tabProps, {
    flowTarget: _network.FlowTargetSourceDest.source,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/:tabName(${_types.NetworkRouteType.anomalies})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_anomalies_query_tab_body.AnomaliesQueryTabBody, (0, _extends2.default)({}, anomaliesProps, {
    AnomaliesTableComponent: _anomalies_network_table.AnomaliesNetworkTable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/:tabName(${_types.NetworkRouteType.events})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_events_tab.EventsQueryTabBody, (0, _extends2.default)({
    additionalFilters: _utils.sourceOrDestinationIpExistsFilter,
    tableId: _securitysolutionDataTable.TableId.networkPageEvents
  }, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }))));
});
NetworkRoutes.displayName = 'NetworkRoutes';