"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTlsColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _helpers = require("../../../../common/components/tables/helpers");
var _localized_date_tooltip = require("../../../../common/components/localized_date_tooltip");
var _formatted_date = require("../../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/tls_table/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getTlsColumns = tableId => [{
  field: 'node',
  name: i18n.ISSUER,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: ({
    _id,
    issuers
  }) => (0, _helpers.getRowItemsWithActions)({
    values: issuers,
    fieldName: 'tls.server.issuer',
    idPrefix: `${tableId}-${_id}-table-issuers`
  })
}, {
  field: 'node',
  name: i18n.SUBJECT,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: ({
    _id,
    subjects
  }) => (0, _helpers.getRowItemsWithActions)({
    values: subjects,
    fieldName: 'tls.server.subject',
    idPrefix: `${tableId}-${_id}-table-subjects`
  })
}, {
  field: 'node._id',
  name: i18n.SHA1_FINGERPRINT,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: sha1 => (0, _helpers.getRowItemsWithActions)({
    values: sha1 ? [sha1] : undefined,
    fieldName: 'tls.server.hash.sha1',
    idPrefix: `${tableId}-${sha1}-table-sha1`
  })
}, {
  field: 'node',
  name: i18n.JA3_FINGERPRINT,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: ({
    _id,
    ja3
  }) => (0, _helpers.getRowItemsWithActions)({
    values: ja3,
    fieldName: 'tls.server.ja3s',
    idPrefix: `${tableId}-${_id}-table-ja3`
  })
}, {
  field: 'node',
  name: i18n.VALID_UNTIL,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: ({
    _id,
    notAfter
  }) => (0, _helpers.getRowItemsWithActions)({
    values: notAfter,
    fieldName: 'tls.server.not_after',
    idPrefix: `${tableId}-${_id}-table-notAfter`,
    render: validUntil => /*#__PURE__*/_react.default.createElement(_localized_date_tooltip.LocalizedDateTooltip, {
      date: (0, _moment.default)(new Date(validUntil)).toDate(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(validUntil),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }))
  })
}];
exports.getTlsColumns = getTlsColumns;