"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkKpiNetworkEvents = exports.ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _kpi_network_events = require("../../../../../common/components/visualization_actions/lens_attributes/network/kpi_network_events");
var _kpi = require("../../../../components/kpi");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/kpi_network/network_events/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ID = exports.ID = 'networkKpiNetworkEventsQuery';
const useGetNetworkEventsStatsItems = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.useMemo)(() => [{
    key: 'networkEvents',
    fields: [{
      key: 'networkEvents',
      color: euiTheme.colors.vis.euiColorVis1,
      lensAttributes: _kpi_network_events.kpiNetworkEventsLensAttributes
    }],
    description: i18n.NETWORK_EVENTS
  }], [euiTheme.colors.vis.euiColorVis1]);
};
const NetworkKpiNetworkEventsComponent = ({
  from,
  to
}) => {
  const networkEventsStatsItems = useGetNetworkEventsStatsItems();
  return /*#__PURE__*/_react.default.createElement(_kpi.KpiBaseComponent, {
    id: ID,
    statItems: networkEventsStatsItems,
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 10
    }
  });
};
const NetworkKpiNetworkEvents = exports.NetworkKpiNetworkEvents = /*#__PURE__*/_react.default.memo(NetworkKpiNetworkEventsComponent);