"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternsMissingPromptComponent = exports.IndexPatternsMissingPrompt = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _kibana = require("../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/embeddables/index_patterns_missing_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexPatternsMissingPromptComponent = () => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const kibanaBasePath = `${(0, _kibana.useBasePath)()}/app`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "gisApp",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 14
      }
    }, i18n.ERROR_TITLE),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "To display map data, you must define SIEM indices ({defaultIndex}) and Kibana index patterns with matching glob patterns. When using {beats}, you can run the {setup} command on your hosts to automatically create the index patterns. For example: {example}.",
      id: "xpack.securitySolution.components.embeddables.indexPatternsMissingPrompt.errorDescription1",
      values: {
        defaultIndex: /*#__PURE__*/_react.default.createElement("a", {
          href: `${kibanaBasePath}/management/kibana/settings`,
          rel: "noopener noreferrer",
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 32,
            columnNumber: 19
          }
        }, 'securitySolution:defaultIndex'),
        beats: /*#__PURE__*/_react.default.createElement("a", {
          href: `${docLinks.links.libbeat.getStarted}`,
          rel: "noopener noreferrer",
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 41,
            columnNumber: 19
          }
        }, 'beats'),
        setup: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 49,
            columnNumber: 24
          }
        }, 'setup'),
        example: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 50,
            columnNumber: 26
          }
        }, './packetbeat setup')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "You can also configure index patterns manually in Kibana.",
      id: "xpack.securitySolution.components.embeddables.indexPatternsMissingPrompt.errorDescription2",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: `${kibanaBasePath}/management/kibana/dataViews`,
      color: "primary",
      target: "_blank",
      fill: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 9
      }
    }, i18n.ERROR_BUTTON),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 5
    }
  });
};
exports.IndexPatternsMissingPromptComponent = IndexPatternsMissingPromptComponent;
IndexPatternsMissingPromptComponent.displayName = 'IndexPatternsMissingPromptComponent';
const IndexPatternsMissingPrompt = exports.IndexPatternsMissingPrompt = /*#__PURE__*/_react.default.memo(IndexPatternsMissingPromptComponent);
IndexPatternsMissingPrompt.displayName = 'IndexPatternsMissingPrompt';