"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutRiskSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _i18n = require("@kbn/i18n");
var _fp = require("lodash/fp");
var _types = require("../../../../common/entity_analytics/types");
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
var _left_panel_header = require("../../../flyout/entity_details/shared/components/left_panel/left_panel_header");
var _inspect = require("../../../common/components/inspect");
var _constants = require("../../../flyout/entity_details/shared/constants");
var _formatted_date = require("../../../common/components/formatted_date");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
var _expandable_panel = require("../../../flyout/shared/components/expandable_panel");
var _risk_score_summary = require("../../lens_attributes/risk_score_summary");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _common = require("./common");
var _telemetry = require("../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/risk_summary_flyout/risk_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FlyoutRiskSummaryComponent = ({
  riskScoreData,
  entityType,
  recalculatingScore,
  queryId,
  openDetailsPanel,
  isLinkEnabled,
  isPreviewMode
}) => {
  var _entityData$risk2;
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services;
  const {
    data
  } = riskScoreData;
  const riskData = data && data.length > 0 ? data[0] : undefined;
  const entityData = (0, _common.getEntityData)(entityType, riskData);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  const lensAttributes = (0, _react.useMemo)(() => {
    var _entityData$name, _entityData$risk;
    const entityName = (_entityData$name = entityData === null || entityData === void 0 ? void 0 : entityData.name) !== null && _entityData$name !== void 0 ? _entityData$name : '';
    const fieldName = _types.EntityTypeToIdentifierField[entityType];
    return (0, _risk_score_summary.getRiskScoreSummaryAttributes)({
      severity: entityData === null || entityData === void 0 ? void 0 : (_entityData$risk = entityData.risk) === null || _entityData$risk === void 0 ? void 0 : _entityData$risk.calculated_level,
      query: `${fieldName}: "${entityName}"`,
      spaceId,
      riskEntity: entityType
    });
  }, [entityData === null || entityData === void 0 ? void 0 : entityData.name, entityData === null || entityData === void 0 ? void 0 : (_entityData$risk2 = entityData.risk) === null || _entityData$risk2 === void 0 ? void 0 : _entityData$risk2.calculated_level, entityType, spaceId]);
  const xsFontSize = (0, _eui.useEuiFontSize)('xxs').fontSize;
  const rows = (0, _react.useMemo)(() => (0, _common.getItems)(entityData), [entityData]);
  const onToggle = (0, _react.useCallback)(isOpen => {
    telemetry.reportEvent(_telemetry.EntityEventTypes.ToggleRiskSummaryClicked, {
      entity: entityType,
      action: isOpen ? 'show' : 'hide'
    });
  }, [entityType, telemetry]);
  const casesAttachmentMetadata = (0, _react.useMemo)(() => ({
    description: _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.riskSummary.casesAttachmentLabel', {
      defaultMessage: 'Risk score for {entityType, select, user {user} other {host}} {entityName}',
      values: {
        entityName: entityData === null || entityData === void 0 ? void 0 : entityData.name,
        entityType
      }
    })
  }), [entityData === null || entityData === void 0 ? void 0 : entityData.name, entityType]);
  const riskDataTimestamp = riskData === null || riskData === void 0 ? void 0 : riskData['@timestamp'];
  const timerange = (0, _react.useMemo)(() => {
    var _dateMath$parse$toISO, _dateMath$parse, _dateMath$parse$toISO2, _dateMath$parse2;
    const from = (_dateMath$parse$toISO = (_dateMath$parse = _datemath.default.parse(_common.LAST_30_DAYS.from)) === null || _dateMath$parse === void 0 ? void 0 : _dateMath$parse.toISOString()) !== null && _dateMath$parse$toISO !== void 0 ? _dateMath$parse$toISO : _common.LAST_30_DAYS.from;
    const to = (_dateMath$parse$toISO2 = (_dateMath$parse2 = _datemath.default.parse(_common.LAST_30_DAYS.to)) === null || _dateMath$parse2 === void 0 ? void 0 : _dateMath$parse2.toISOString()) !== null && _dateMath$parse$toISO2 !== void 0 ? _dateMath$parse$toISO2 : _common.LAST_30_DAYS.to;
    return {
      from,
      to
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [riskDataTimestamp]); // Update the timerange whenever the risk score timestamp changes to include new entries

  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    onToggle: onToggle,
    initialIsOpen: true,
    id: 'risk_summary',
    buttonProps: {
      css: (0, _react2.css)`
          color: ${euiTheme.colors.primary};
        `
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.title",
      defaultMessage: "{entity} risk summary",
      values: {
        entity: (0, _fp.capitalize)(entityType)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 13
      }
    }))),
    extraAction: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "risk-summary-updatedAt",
      css: (0, _react2.css)`
            font-size: ${xsFontSize};
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 9
      }
    }, riskData && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskUpdatedTime",
      defaultMessage: "Updated {time}",
      values: {
        time: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
          value: riskData['@timestamp'],
          dateFormat: "MMM D, YYYY",
          relativeThresholdInHrs: _constants.ONE_WEEK_IN_HOURS,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 158,
            columnNumber: 19
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    "data-test-subj": "riskInputs",
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs",
        defaultMessage: "View risk contributions",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 13
        }
      }),
      link: riskScoreData.loading ? undefined : {
        callback: isLinkEnabled ? () => openDetailsPanel({
          tab: _left_panel_header.EntityDetailsLeftPanelTab.RISK_INPUTS
        }) : undefined,
        tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.entityDetails.showAllRiskInputs",
          defaultMessage: "Show all risk inputs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 188,
            columnNumber: 19
          }
        })
      },
      iconType: !isPreviewMode ? 'arrowStart' : undefined
    },
    expand: {
      expandable: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "row",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    // Improve Visualization loading state by predefining the size
    // Set min-width for a fluid layout
    css: (0, _react2.css)`
                height: ${_common.LENS_VISUALIZATION_HEIGHT}px;
                min-width: ${_common.LENS_VISUALIZATION_MIN_WIDTH}px;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, riskData && /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: false,
    applyPageAndTabsFilters: false,
    lensAttributes: lensAttributes,
    id: `RiskSummary-risk_score_metric`,
    timerange: timerange,
    width: '100%',
    height: _common.LENS_VISUALIZATION_HEIGHT,
    disableOnClickFilter: true,
    inspectTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.inspectVisualizationTitle",
      defaultMessage: "Risk Summary Visualization",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 21
      }
    }),
    casesAttachmentMetadata: casesAttachmentMetadata,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    css: (0, _react2.css)`
              min-width: ${_common.SUMMARY_TABLE_MIN_WIDTH}px;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    // Anchors the position absolute inspect button (nearest positioned ancestor)
    css: (0, _react2.css)`
                  position: relative;
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    // Position the inspect button above the table
    css: (0, _react2.css)`
                    position: absolute;
                    right: 0;
                    top: -${euiTheme.size.base};
                  `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: queryId,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.inspectTableTitle",
      defaultMessage: "Risk Summary Table",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 23
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "risk-summary-table",
    responsiveBreakpoint: false,
    columns: _common.columnsArray,
    items: rows,
    compressed: true,
    loading: riskScoreData.loading || recalculatingScore,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 7
    }
  }));
};
const FlyoutRiskSummary = exports.FlyoutRiskSummary = /*#__PURE__*/_react.default.memo(FlyoutRiskSummaryComponent); // This is needed to male React.memo work with generic
FlyoutRiskSummary.displayName = 'RiskSummary';