"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedAccessDetectionMLPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _public = require("@kbn/ml-plugin/public");
var _pad_ml_popover_header = require("./pad_ml_popover_header");
var _use_enable_data_feed = require("../../../../../../common/components/ml_popover/hooks/use_enable_data_feed");
var _jobs_table = require("../../../../../../common/components/ml_popover/jobs_table/jobs_table");
var _pad_get_jobs_hooks = require("./hooks/pad_get_jobs_hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/privileged_access_detection/pad_ml_popover/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PrivilegedAccessDetectionMLPopover = () => {
  const {
    enableDatafeed,
    disableDatafeed,
    isLoading: isLoadingEnableDataFeed
  } = (0, _use_enable_data_feed.useEnableDataFeed)();
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const {
    jobs,
    refreshJobs,
    isLoadingSecurityJobs,
    isMlAdmin
  } = (0, _pad_get_jobs_hooks.usePadMlJobs)(searchValue);
  const handleJobStateChange = (0, _react.useCallback)(async (job, latestTimestampMs, enable) => {
    if (enable) {
      await enableDatafeed(job, latestTimestampMs);
    } else {
      await disableDatafeed(job);
    }
    refreshJobs();
  }, [refreshJobs, enableDatafeed, disableDatafeed]);
  const [mlNodesAvailable, setMlNodesAvailable] = (0, _react.useState)(false);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const installedJobsIds = jobs.filter(job => job.isInstalled).map(job => job.id);
  if (!isMlAdmin) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    id: "privileged-access-detections-popover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-expanded": isPopoverOpen,
      "aria-haspopup": "true",
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.popupAria', {
        defaultMessage: 'Privileged Access Detection popup'
      }),
      color: "primary",
      "data-test-subj": "privileged-access-detections-popover-button",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
        refreshJobs();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.padMlJobsPopoverText', {
      defaultMessage: 'Privileged access detection ML Jobs'
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(!isPopoverOpen),
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    css: (0, _react2.css)`
            max-width: 700px;
            max-height: 90vh;
            overflow-y: auto;
            overflow-x: hidden;
            padding-bottom: 15px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_pad_ml_popover_header.PrivilegedAccessDetectionMLPopoverHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    placeholder: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.searchPlaceholder', {
      defaultMessage: 'e.g., Linux, Okta, etc.'
    }),
    value: searchValue,
    fullWidth: true,
    onChange: e => setSearchValue(e.target.value),
    isClearable: true,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.searchAria', {
      defaultMessage: 'Privileged access detection search box'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_public.MLJobsAwaitingNodeWarning, {
    jobIds: installedJobsIds,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_public.MlNodeAvailableWarningShared, {
    size: "s",
    nodeAvailableCallback: setMlNodesAvailable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_jobs_table.JobsTable, {
    isLoading: isLoadingSecurityJobs || isLoadingEnableDataFeed,
    jobs: jobs,
    onJobStateChange: handleJobStateChange,
    mlNodesAvailable: mlNodesAvailable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }))));
};
exports.PrivilegedAccessDetectionMLPopover = PrivilegedAccessDetectionMLPopover;