"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumns = exports.HEALTH_COLOR = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _entity_analytics = require("../../../../../../../common/api/entity_analytics");
var _kibana = require("../../../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_store/components/engines_status/hooks/use_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HEALTH_COLOR = exports.HEALTH_COLOR = {
  green: 'success',
  unknown: 'subdued',
  yellow: 'warning',
  red: 'danger',
  unavailable: 'danger'
};
const RESOURCE_TO_TEXT = {
  ingest_pipeline: 'Ingest Pipeline',
  enrich_policy: 'Enrich Policy',
  index: 'Index',
  component_template: 'Component Template',
  task: 'Task',
  transform: 'Transform',
  entity_definition: 'Entity Definition',
  entity_engine: 'Engine',
  index_template: 'Index Template',
  ilm_policy: 'ILM Policy',
  data_stream: 'Data stream'
};
const useColumns = (onToggleExpandedItem, expandedItems) => {
  const {
    getUrlForApp
  } = (0, _kibana.useKibana)().services.application;
  return (0, _react.useMemo)(() => [{
    field: 'resource',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.resourceColumnTitle",
      defaultMessage: "Resource",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }),
    width: '20%',
    render: resource => RESOURCE_TO_TEXT[resource]
  }, {
    field: 'id',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.idColumnTitle",
      defaultMessage: "Identifier",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }),
    render: (id, {
      resource,
      installed
    }) => {
      const path = getResourcePath(id, resource);
      if (!installed || !path) {
        return id;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: getUrlForApp('management', {
          path
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 13
        }
      }, id);
    }
  }, {
    field: 'installed',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.installedColumnTitle",
      defaultMessage: "Installed",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    }),
    width: '10%',
    align: 'center',
    render: value => value ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": "installation-status",
      type: "check",
      color: "success",
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": "installation-status",
      type: "cross",
      color: "danger",
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 13
      }
    })
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.healthColumnTitle",
      defaultMessage: "Health",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 11
      }
    }),
    width: '10%',
    align: 'center',
    render: ({
      installed,
      resource,
      health
    }) => {
      if (!installed) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: HEALTH_COLOR[health !== null && health !== void 0 ? health : 'green'],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 18
        }
      });
    }
  }, {
    isExpander: true,
    align: 'right',
    width: '40px',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.expandRow",
      defaultMessage: "Expand row",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 15
      }
    }))),
    mobileOptions: {
      header: false
    },
    render: component => {
      const isItemExpanded = expandedItems.includes(component);
      return component.errors && component.errors.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => onToggleExpandedItem(component),
        "aria-label": isItemExpanded ? 'Collapse' : 'Expand',
        iconType: isItemExpanded ? 'arrowDown' : 'arrowRight',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 13
        }
      }) : null;
    }
  }], [expandedItems, getUrlForApp, onToggleExpandedItem]);
};
exports.useColumns = useColumns;
const getResourcePath = (id, resource) => {
  if (resource === _entity_analytics.EngineComponentResourceEnum.ingest_pipeline) {
    return `ingest/ingest_pipelines?pipeline=${id}`;
  }
  if (resource === _entity_analytics.EngineComponentResourceEnum.index_template) {
    return `data/index_management/templates/${id}`;
  }
  if (resource === _entity_analytics.EngineComponentResourceEnum.index) {
    return `data/index_management/indices/index_details?indexName=${id}`;
  }
  if (resource === _entity_analytics.EngineComponentResourceEnum.component_template) {
    return `data/index_management/component_templates/${id}`;
  }
  if (resource === _entity_analytics.EngineComponentResourceEnum.enrich_policy) {
    return `data/index_management/enrich_policies?policy=${id}`;
  }
  if (resource === _entity_analytics.EngineComponentResourceEnum.transform) {
    return `data/transform?_a=(transform:(queryText:'${id}'))`;
  }
  if (resource === _entity_analytics.EngineComponentResourceEnum.ilm_policy) {
    return `data/index_lifecycle_management/policies?policy=${id}`;
  }
  if (resource === _entity_analytics.EngineComponentResourceEnum.data_stream) {
    return `data/index_management/data_streams/${id}`;
  }
  return null;
};